/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Arrays;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.KeyGenerator;

public class ComplexKeyGenerator
extends KeyGenerator {
    private static final String DEFAULT_PARTITION_PATH = "default";
    private static final String DEFAULT_PARTITION_PATH_SEPARATOR = "/";
    protected static final String NULL_RECORDKEY_PLACEHOLDER = "__null__";
    protected static final String EMPTY_RECORDKEY_PLACEHOLDER = "__empty__";
    protected final List<String> recordKeyFields;
    protected final List<String> partitionPathFields;
    protected final boolean hiveStylePartitioning;

    public ComplexKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyFields = Arrays.asList(props.getString(DataSourceWriteOptions.RECORDKEY_FIELD_OPT_KEY()).split(","));
        this.partitionPathFields = Arrays.asList(props.getString(DataSourceWriteOptions.PARTITIONPATH_FIELD_OPT_KEY()).split(","));
        this.hiveStylePartitioning = props.getBoolean(DataSourceWriteOptions.HIVE_STYLE_PARTITIONING_OPT_KEY(), Boolean.parseBoolean(DataSourceWriteOptions.DEFAULT_HIVE_STYLE_PARTITIONING_OPT_VAL()));
    }

    @Override
    public HoodieKey getKey(GenericRecord record) {
        if (this.recordKeyFields == null || this.partitionPathFields == null) {
            throw new HoodieKeyException("Unable to find field names for record key or partition path in cfg");
        }
        boolean keyIsNullEmpty = true;
        StringBuilder recordKey = new StringBuilder();
        for (String recordKeyField : this.recordKeyFields) {
            String recordKeyValue = DataSourceUtils.getNestedFieldValAsString(record, recordKeyField, true);
            if (recordKeyValue == null) {
                recordKey.append(recordKeyField + ":" + NULL_RECORDKEY_PLACEHOLDER + ",");
                continue;
            }
            if (recordKeyValue.isEmpty()) {
                recordKey.append(recordKeyField + ":" + EMPTY_RECORDKEY_PLACEHOLDER + ",");
                continue;
            }
            recordKey.append(recordKeyField + ":" + recordKeyValue + ",");
            keyIsNullEmpty = false;
        }
        recordKey.deleteCharAt(recordKey.length() - 1);
        if (keyIsNullEmpty) {
            throw new HoodieKeyException("recordKey values: \"" + recordKey + "\" for fields: " + this.recordKeyFields.toString() + " cannot be entirely null or empty.");
        }
        StringBuilder partitionPath = new StringBuilder();
        for (String partitionPathField : this.partitionPathFields) {
            String fieldVal = DataSourceUtils.getNestedFieldValAsString(record, partitionPathField, true);
            if (fieldVal == null || fieldVal.isEmpty()) {
                partitionPath.append(this.hiveStylePartitioning ? partitionPathField + "=" + DEFAULT_PARTITION_PATH : DEFAULT_PARTITION_PATH);
            } else {
                partitionPath.append(this.hiveStylePartitioning ? partitionPathField + "=" + fieldVal : fieldVal);
            }
            partitionPath.append(DEFAULT_PARTITION_PATH_SEPARATOR);
        }
        partitionPath.deleteCharAt(partitionPath.length() - 1);
        return new HoodieKey(recordKey.toString(), partitionPath.toString());
    }

    public List<String> getRecordKeyFields() {
        return this.recordKeyFields;
    }

    public List<String> getPartitionPathFields() {
        return this.partitionPathFields;
    }
}

