/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Arrays;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.KeyGenerator;

public class GlobalDeleteKeyGenerator
extends KeyGenerator {
    private static final String EMPTY_PARTITION = "";
    private static final String NULL_RECORDKEY_PLACEHOLDER = "__null__";
    private static final String EMPTY_RECORDKEY_PLACEHOLDER = "__empty__";
    protected final List<String> recordKeyFields;

    public GlobalDeleteKeyGenerator(TypedProperties config) {
        super(config);
        this.recordKeyFields = Arrays.asList(config.getString(DataSourceWriteOptions.RECORDKEY_FIELD_OPT_KEY()).split(","));
    }

    @Override
    public HoodieKey getKey(GenericRecord record) {
        if (this.recordKeyFields == null) {
            throw new HoodieKeyException("Unable to find field names for record key or partition path in cfg");
        }
        boolean keyIsNullEmpty = true;
        StringBuilder recordKey = new StringBuilder();
        for (String recordKeyField : this.recordKeyFields) {
            String recordKeyValue = DataSourceUtils.getNestedFieldValAsString(record, recordKeyField, true);
            if (recordKeyValue == null) {
                recordKey.append(recordKeyField + ":" + NULL_RECORDKEY_PLACEHOLDER + ",");
                continue;
            }
            if (recordKeyValue.isEmpty()) {
                recordKey.append(recordKeyField + ":" + EMPTY_RECORDKEY_PLACEHOLDER + ",");
                continue;
            }
            recordKey.append(recordKeyField + ":" + recordKeyValue + ",");
            keyIsNullEmpty = false;
        }
        recordKey.deleteCharAt(recordKey.length() - 1);
        if (keyIsNullEmpty) {
            throw new HoodieKeyException("recordKey values: \"" + recordKey + "\" for fields: " + this.recordKeyFields.toString() + " cannot be entirely null or empty.");
        }
        return new HoodieKey(recordKey.toString(), EMPTY_PARTITION);
    }
}

