/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.SimpleKeyGenerator;

public class NonpartitionedKeyGenerator
extends SimpleKeyGenerator {
    private static final String EMPTY_PARTITION = "";

    public NonpartitionedKeyGenerator(TypedProperties props) {
        super(props);
    }

    @Override
    public HoodieKey getKey(GenericRecord record) {
        String recordKey = DataSourceUtils.getNestedFieldValAsString(record, this.recordKeyField, true);
        if (recordKey == null || recordKey.isEmpty()) {
            throw new HoodieKeyException("recordKey value: \"" + recordKey + "\" for field: \"" + this.recordKeyField + "\" cannot be null or empty.");
        }
        return new HoodieKey(recordKey, EMPTY_PARTITION);
    }
}

