/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.KeyGenerator;

public class SimpleKeyGenerator
extends KeyGenerator {
    private static final String DEFAULT_PARTITION_PATH = "default";
    protected final String recordKeyField;
    protected final String partitionPathField;
    protected final boolean hiveStylePartitioning;

    public SimpleKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyField = props.getString(DataSourceWriteOptions.RECORDKEY_FIELD_OPT_KEY());
        this.partitionPathField = props.getString(DataSourceWriteOptions.PARTITIONPATH_FIELD_OPT_KEY());
        this.hiveStylePartitioning = props.getBoolean(DataSourceWriteOptions.HIVE_STYLE_PARTITIONING_OPT_KEY(), Boolean.parseBoolean(DataSourceWriteOptions.DEFAULT_HIVE_STYLE_PARTITIONING_OPT_VAL()));
    }

    @Override
    public HoodieKey getKey(GenericRecord record) {
        if (this.recordKeyField == null || this.partitionPathField == null) {
            throw new HoodieKeyException("Unable to find field names for record key or partition path in cfg");
        }
        String recordKey = DataSourceUtils.getNestedFieldValAsString(record, this.recordKeyField, true);
        if (recordKey == null || recordKey.isEmpty()) {
            throw new HoodieKeyException("recordKey value: \"" + recordKey + "\" for field: \"" + this.recordKeyField + "\" cannot be null or empty.");
        }
        String partitionPath = DataSourceUtils.getNestedFieldValAsString(record, this.partitionPathField, true);
        if (partitionPath == null || partitionPath.isEmpty()) {
            partitionPath = DEFAULT_PARTITION_PATH;
        }
        if (this.hiveStylePartitioning) {
            partitionPath = this.partitionPathField + "=" + partitionPath;
        }
        return new HoodieKey(recordKey, partitionPath);
    }
}

