/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class JmxMetricsReporter
extends MetricsReporter {
    private static final Logger LOG = LogManager.getLogger(JmxMetricsReporter.class);
    private final JMXConnectorServer connector;

    public JmxMetricsReporter(HoodieWriteConfig config) {
        try {
            String host = config.getJmxHost();
            int port = config.getJmxPort();
            if (host == null || port == 0) {
                throw new RuntimeException(String.format("Jmx cannot be initialized with host[%s] and port[%s].", host, port));
            }
            LocateRegistry.createRegistry(port);
            String serviceUrl = "service:jmx:rmi://" + host + ":" + port + "/jndi/rmi://" + host + ":" + port + "/jmxrmi";
            JMXServiceURL url = new JMXServiceURL(serviceUrl);
            this.connector = JMXConnectorServerFactory.newJMXConnectorServer(url, null, ManagementFactory.getPlatformMBeanServer());
        }
        catch (Exception e) {
            String msg = "Jmx initialize failed: ";
            LOG.error((Object)msg, (Throwable)e);
            throw new HoodieException(msg, e);
        }
    }

    @Override
    public void start() {
        try {
            Preconditions.checkNotNull((Object)this.connector, (Object)"Cannot start as the jmxReporter is null.");
            this.connector.start();
        }
        catch (Exception e) {
            throw new HoodieException(e);
        }
    }

    @Override
    public void report() {
    }

    @Override
    public Closeable getReporter() {
        return null;
    }
}

