/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.google.common.io.Closeables;
import java.io.Closeable;
import org.apache.hudi.com.codahale.metrics.MetricRegistry;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.MetricsReporterFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Metrics {
    private static final Logger LOG = LogManager.getLogger(Metrics.class);
    private static volatile boolean initialized = false;
    private static Metrics metrics = null;
    private final MetricRegistry registry = new MetricRegistry();
    private MetricsReporter reporter;

    private Metrics(HoodieWriteConfig metricConfig) {
        this.reporter = MetricsReporterFactory.createReporter(metricConfig, this.registry);
        if (this.reporter == null) {
            throw new RuntimeException("Cannot initialize Reporter.");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Metrics.this.reporter.report();
                    Closeables.close((Closeable)Metrics.this.reporter.getReporter(), (boolean)true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static Metrics getInstance() {
        assert (initialized);
        return metrics;
    }

    public static synchronized void init(HoodieWriteConfig metricConfig) {
        if (initialized) {
            return;
        }
        try {
            metrics = new Metrics(metricConfig);
        }
        catch (Exception e) {
            throw new HoodieException(e);
        }
        initialized = true;
    }

    public static void registerGauge(String metricName, long value) {
        try {
            MetricRegistry registry = Metrics.getInstance().getRegistry();
            registry.register(metricName, () -> value);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to send metrics: ", (Throwable)e);
        }
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public Closeable getReporter() {
        return this.reporter.getReporter();
    }
}

