/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.com.codahale.metrics.MetricFilter;
import org.apache.hudi.com.codahale.metrics.MetricRegistry;
import org.apache.hudi.com.codahale.metrics.graphite.Graphite;
import org.apache.hudi.com.codahale.metrics.graphite.GraphiteReporter;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MetricsGraphiteReporter
extends MetricsReporter {
    private static final Logger LOG = LogManager.getLogger(MetricsGraphiteReporter.class);
    private final MetricRegistry registry;
    private final GraphiteReporter graphiteReporter;
    private final HoodieWriteConfig config;
    private String serverHost;
    private int serverPort;

    public MetricsGraphiteReporter(HoodieWriteConfig config, MetricRegistry registry) {
        this.registry = registry;
        this.config = config;
        this.serverHost = config.getGraphiteServerHost();
        this.serverPort = config.getGraphiteServerPort();
        if (this.serverHost == null || this.serverPort == 0) {
            throw new RuntimeException(String.format("Graphite cannot be initialized with serverHost[%s] and serverPort[%s].", this.serverHost, this.serverPort));
        }
        this.graphiteReporter = this.createGraphiteReport();
    }

    @Override
    public void start() {
        if (this.graphiteReporter != null) {
            this.graphiteReporter.start(30L, TimeUnit.SECONDS);
        } else {
            LOG.error((Object)"Cannot start as the graphiteReporter is null.");
        }
    }

    @Override
    public void report() {
        if (this.graphiteReporter != null) {
            this.graphiteReporter.report();
        } else {
            LOG.error((Object)"Cannot report metrics as the graphiteReporter is null.");
        }
    }

    @Override
    public Closeable getReporter() {
        return this.graphiteReporter;
    }

    private GraphiteReporter createGraphiteReport() {
        Graphite graphite = new Graphite(new InetSocketAddress(this.serverHost, this.serverPort));
        String reporterPrefix = this.config.getGraphiteMetricPrefix();
        return GraphiteReporter.forRegistry(this.registry).prefixedWith(reporterPrefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
    }
}

