/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import org.apache.hudi.com.codahale.metrics.MetricRegistry;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.InMemoryMetricsReporter;
import org.apache.hudi.metrics.JmxMetricsReporter;
import org.apache.hudi.metrics.MetricsGraphiteReporter;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MetricsReporterFactory {
    private static final Logger LOG = LogManager.getLogger(MetricsReporterFactory.class);

    public static MetricsReporter createReporter(HoodieWriteConfig config, MetricRegistry registry) {
        MetricsReporterType type = config.getMetricsReporterType();
        MetricsReporter reporter = null;
        switch (type) {
            case GRAPHITE: {
                reporter = new MetricsGraphiteReporter(config, registry);
                break;
            }
            case INMEMORY: {
                reporter = new InMemoryMetricsReporter();
                break;
            }
            case JMX: {
                reporter = new JmxMetricsReporter(config);
                break;
            }
            default: {
                LOG.error((Object)("Reporter type[" + (Object)((Object)type) + "] is not supported."));
            }
        }
        return reporter;
    }
}

