/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.WriteStatus;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.client.utils.ClientUtils;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.SerializableConfiguration;
import org.apache.hudi.common.io.storage.HoodieWrapperFileSystem;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.SyncableFileSystemView;
import org.apache.hudi.common.table.TableFileSystemView;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.AvroUtils;
import org.apache.hudi.common.util.ConsistencyGuard;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.FailSafeConsistencyGuard;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieCopyOnWriteTable;
import org.apache.hudi.table.HoodieMergeOnReadTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;

public abstract class HoodieTable<T extends HoodieRecordPayload>
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(HoodieTable.class);
    protected final HoodieWriteConfig config;
    protected final HoodieTableMetaClient metaClient;
    protected final HoodieIndex<T> index;
    private SerializableConfiguration hadoopConfiguration;
    private transient FileSystemViewManager viewManager;

    protected HoodieTable(HoodieWriteConfig config, JavaSparkContext jsc) {
        this.config = config;
        this.hadoopConfiguration = new SerializableConfiguration(jsc.hadoopConfiguration());
        this.viewManager = FileSystemViewManager.createViewManager(new SerializableConfiguration(jsc.hadoopConfiguration()), config.getViewStorageConfig());
        this.metaClient = ClientUtils.createMetaClient(jsc, config, true);
        this.index = HoodieIndex.createIndex(config, jsc);
    }

    private synchronized FileSystemViewManager getViewManager() {
        if (null == this.viewManager) {
            this.viewManager = FileSystemViewManager.createViewManager(this.hadoopConfiguration, this.config.getViewStorageConfig());
        }
        return this.viewManager;
    }

    public static <T extends HoodieRecordPayload> HoodieTable<T> getHoodieTable(HoodieTableMetaClient metaClient, HoodieWriteConfig config, JavaSparkContext jsc) {
        switch (metaClient.getTableType()) {
            case COPY_ON_WRITE: {
                return new HoodieCopyOnWriteTable(config, jsc);
            }
            case MERGE_ON_READ: {
                return new HoodieMergeOnReadTable(config, jsc);
            }
        }
        throw new HoodieException("Unsupported table type :" + (Object)((Object)metaClient.getTableType()));
    }

    public abstract Partitioner getUpsertPartitioner(WorkloadProfile var1);

    public abstract Partitioner getInsertPartitioner(WorkloadProfile var1);

    public abstract boolean isWorkloadProfileNeeded();

    public HoodieWriteConfig getConfig() {
        return this.config;
    }

    public HoodieTableMetaClient getMetaClient() {
        return this.metaClient;
    }

    public Configuration getHadoopConf() {
        return this.metaClient.getHadoopConf();
    }

    public TableFileSystemView getFileSystemView() {
        return new HoodieTableFileSystemView(this.metaClient, this.getCompletedCommitsTimeline());
    }

    public TableFileSystemView.BaseFileOnlyView getBaseFileOnlyView() {
        return this.getViewManager().getFileSystemView(this.metaClient.getBasePath());
    }

    public TableFileSystemView.SliceView getSliceView() {
        return this.getViewManager().getFileSystemView(this.metaClient.getBasePath());
    }

    public SyncableFileSystemView getHoodieView() {
        return this.getViewManager().getFileSystemView(this.metaClient.getBasePath());
    }

    public HoodieTimeline getCompletedCommitsTimeline() {
        return this.metaClient.getCommitsTimeline().filterCompletedInstants();
    }

    public HoodieTimeline getCompletedCommitTimeline() {
        return this.metaClient.getCommitTimeline().filterCompletedInstants();
    }

    public HoodieTimeline getPendingCommitTimeline() {
        return this.metaClient.getCommitsTimeline().filterPendingExcludingCompaction();
    }

    public HoodieTimeline getCompletedCleanTimeline() {
        return this.getActiveTimeline().getCleanerTimeline().filterCompletedInstants();
    }

    public HoodieTimeline getCleanTimeline() {
        return this.getActiveTimeline().getCleanerTimeline();
    }

    public HoodieTimeline getCompletedSavepointTimeline() {
        return this.getActiveTimeline().getSavePointTimeline().filterCompletedInstants();
    }

    public List<String> getSavepoints() {
        return this.getCompletedSavepointTimeline().getInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
    }

    public Stream<String> getSavepointedDataFiles(String savepointTime) {
        HoodieSavepointMetadata metadata;
        if (!this.getSavepoints().contains(savepointTime)) {
            throw new HoodieSavepointException("Could not get data files for savepoint " + savepointTime + ". No such savepoint.");
        }
        HoodieInstant instant = new HoodieInstant(false, "savepoint", savepointTime);
        try {
            metadata = AvroUtils.deserializeHoodieSavepointMetadata(this.getActiveTimeline().getInstantDetails(instant).get());
        }
        catch (IOException e) {
            throw new HoodieSavepointException("Could not get savepointed data files for savepoint " + savepointTime, e);
        }
        return metadata.getPartitionMetadata().values().stream().flatMap(s -> s.getSavepointDataFile().stream());
    }

    public HoodieActiveTimeline getActiveTimeline() {
        return this.metaClient.getActiveTimeline();
    }

    public HoodieIndex<T> getIndex() {
        return this.index;
    }

    public abstract Iterator<List<WriteStatus>> handleUpsertPartition(String var1, Integer var2, Iterator<HoodieRecord<T>> var3, Partitioner var4);

    public abstract Iterator<List<WriteStatus>> handleInsertPartition(String var1, Integer var2, Iterator<HoodieRecord<T>> var3, Partitioner var4);

    public abstract HoodieCompactionPlan scheduleCompaction(JavaSparkContext var1, String var2);

    public abstract JavaRDD<WriteStatus> compact(JavaSparkContext var1, String var2, HoodieCompactionPlan var3);

    public abstract HoodieCleanerPlan scheduleClean(JavaSparkContext var1);

    public abstract List<HoodieCleanStat> clean(JavaSparkContext var1, HoodieInstant var2, HoodieCleanerPlan var3);

    public abstract List<HoodieRollbackStat> rollback(JavaSparkContext var1, HoodieInstant var2, boolean var3) throws IOException;

    public void finalizeWrite(JavaSparkContext jsc, String instantTs, List<HoodieWriteStat> stats) throws HoodieIOException {
        this.cleanFailedWrites(jsc, instantTs, stats, this.config.getConsistencyGuardConfig().isConsistencyCheckEnabled());
    }

    protected void deleteMarkerDir(String instantTs) {
        try {
            HoodieWrapperFileSystem fs = this.getMetaClient().getFs();
            Path markerDir = new Path(this.metaClient.getMarkerFolderPath(instantTs));
            if (fs.exists(markerDir)) {
                LOG.info((Object)("Removing marker directory=" + markerDir));
                fs.delete(markerDir, true);
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    protected void cleanFailedWrites(JavaSparkContext jsc, String instantTs, List<HoodieWriteStat> stats, boolean consistencyCheckEnabled) throws HoodieIOException {
        try {
            Map<String, List<Pair<String, String>>> groupByPartition;
            String basePath = this.getMetaClient().getBasePath();
            HoodieWrapperFileSystem fs = this.getMetaClient().getFs();
            Path markerDir = new Path(this.metaClient.getMarkerFolderPath(instantTs));
            if (!fs.exists(markerDir)) {
                return;
            }
            List<String> invalidDataPaths = FSUtils.getAllDataFilesForMarkers(fs, basePath, instantTs, markerDir.toString());
            List validDataPaths = stats.stream().map(w -> String.format("%s/%s", basePath, w.getPath())).filter(p -> p.endsWith(".parquet")).collect(Collectors.toList());
            invalidDataPaths.removeAll(validDataPaths);
            if (!invalidDataPaths.isEmpty()) {
                LOG.info((Object)("Removing duplicate data files created due to spark retries before committing. Paths=" + invalidDataPaths));
            }
            if (!(groupByPartition = invalidDataPaths.stream().map(dp -> Pair.of(new Path(dp).getParent().toString(), dp)).collect(Collectors.groupingBy(Pair::getKey))).isEmpty()) {
                if (consistencyCheckEnabled) {
                    this.waitForAllFiles(jsc, groupByPartition, ConsistencyGuard.FileVisibility.APPEAR);
                }
                jsc.parallelize(new ArrayList<List<Pair<String, String>>>(groupByPartition.values()), this.config.getFinalizeWriteParallelism()).map((Function & Serializable)partitionWithFileList -> {
                    HoodieWrapperFileSystem fileSystem = this.metaClient.getFs();
                    LOG.info((Object)("Deleting invalid data files=" + partitionWithFileList));
                    if (partitionWithFileList.isEmpty()) {
                        return true;
                    }
                    partitionWithFileList.stream().map(Pair::getValue).forEach(file -> {
                        try {
                            fileSystem.delete(new Path(file), false);
                        }
                        catch (IOException e) {
                            throw new HoodieIOException(e.getMessage(), e);
                        }
                    });
                    return true;
                }).collect();
                if (consistencyCheckEnabled) {
                    this.waitForAllFiles(jsc, groupByPartition, ConsistencyGuard.FileVisibility.DISAPPEAR);
                }
            }
            this.deleteMarkerDir(instantTs);
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    private void waitForAllFiles(JavaSparkContext jsc, Map<String, List<Pair<String, String>>> groupByPartition, ConsistencyGuard.FileVisibility visibility) {
        boolean checkPassed = jsc.parallelize(new ArrayList<Map.Entry<String, List<Pair<String, String>>>>(groupByPartition.entrySet()), this.config.getFinalizeWriteParallelism()).map((Function & Serializable)partitionWithFileList -> this.waitForCondition((String)partitionWithFileList.getKey(), ((List)partitionWithFileList.getValue()).stream(), visibility)).collect().stream().allMatch(x -> x);
        if (!checkPassed) {
            throw new HoodieIOException("Consistency check failed to ensure all files " + (Object)((Object)visibility));
        }
    }

    private boolean waitForCondition(String partitionPath, Stream<Pair<String, String>> partitionFilePaths, ConsistencyGuard.FileVisibility visibility) {
        FileSystem fileSystem = this.metaClient.getRawFs();
        List<String> fileList = partitionFilePaths.map(Pair::getValue).collect(Collectors.toList());
        try {
            this.getFailSafeConsistencyGuard(fileSystem).waitTill(partitionPath, fileList, visibility);
        }
        catch (IOException | TimeoutException ioe) {
            LOG.error((Object)"Got exception while waiting for files to show up", (Throwable)ioe);
            return false;
        }
        return true;
    }

    private ConsistencyGuard getFailSafeConsistencyGuard(FileSystem fileSystem) {
        return new FailSafeConsistencyGuard(fileSystem, this.config.getConsistencyGuardConfig());
    }
}

