/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;

public class RollbackRequest {
    private final String partitionPath;
    private final HoodieInstant rollbackInstant;
    private final Option<String> fileId;
    private final Option<String> latestBaseInstant;
    private final RollbackAction rollbackAction;

    public RollbackRequest(String partitionPath, HoodieInstant rollbackInstant, Option<String> fileId, Option<String> latestBaseInstant, RollbackAction rollbackAction) {
        this.partitionPath = partitionPath;
        this.rollbackInstant = rollbackInstant;
        this.fileId = fileId;
        this.latestBaseInstant = latestBaseInstant;
        this.rollbackAction = rollbackAction;
    }

    public static RollbackRequest createRollbackRequestWithDeleteDataFilesOnlyAction(String partitionPath, HoodieInstant rollbackInstant) {
        return new RollbackRequest(partitionPath, rollbackInstant, Option.empty(), Option.empty(), RollbackAction.DELETE_DATA_FILES_ONLY);
    }

    public static RollbackRequest createRollbackRequestWithDeleteDataAndLogFilesAction(String partitionPath, HoodieInstant rollbackInstant) {
        return new RollbackRequest(partitionPath, rollbackInstant, Option.empty(), Option.empty(), RollbackAction.DELETE_DATA_AND_LOG_FILES);
    }

    public static RollbackRequest createRollbackRequestWithAppendRollbackBlockAction(String partitionPath, String fileId, String baseInstant, HoodieInstant rollbackInstant) {
        return new RollbackRequest(partitionPath, rollbackInstant, Option.of(fileId), Option.of(baseInstant), RollbackAction.APPEND_ROLLBACK_BLOCK);
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public HoodieInstant getRollbackInstant() {
        return this.rollbackInstant;
    }

    public Option<String> getFileId() {
        return this.fileId;
    }

    public Option<String> getLatestBaseInstant() {
        return this.latestBaseInstant;
    }

    public RollbackAction getRollbackAction() {
        return this.rollbackAction;
    }

    public static enum RollbackAction {
        DELETE_DATA_FILES_ONLY,
        DELETE_DATA_AND_LOG_FILES,
        APPEND_ROLLBACK_BLOCK;

    }
}

