/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.table.WorkloadStat;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class WorkloadProfile<T extends HoodieRecordPayload>
implements Serializable {
    private final JavaRDD<HoodieRecord<T>> taggedRecords;
    private final HashMap<String, WorkloadStat> partitionPathStatMap;
    private final WorkloadStat globalStat;

    public WorkloadProfile(JavaRDD<HoodieRecord<T>> taggedRecords) {
        this.taggedRecords = taggedRecords;
        this.partitionPathStatMap = new HashMap();
        this.globalStat = new WorkloadStat();
        this.buildProfile();
    }

    private void buildProfile() {
        Map partitionLocationCounts = this.taggedRecords.mapToPair((PairFunction & Serializable)record -> new Tuple2((Object)new Tuple2((Object)record.getPartitionPath(), Option.ofNullable(record.getCurrentLocation())), record)).countByKey();
        for (Map.Entry e : partitionLocationCounts.entrySet()) {
            String partitionPath = (String)((Tuple2)e.getKey())._1();
            Long count = (Long)e.getValue();
            Option locOption = (Option)((Tuple2)e.getKey())._2();
            if (!this.partitionPathStatMap.containsKey(partitionPath)) {
                this.partitionPathStatMap.put(partitionPath, new WorkloadStat());
            }
            if (locOption.isPresent()) {
                this.partitionPathStatMap.get(partitionPath).addUpdates((HoodieRecordLocation)locOption.get(), count);
                this.globalStat.addUpdates((HoodieRecordLocation)locOption.get(), count);
                continue;
            }
            this.partitionPathStatMap.get(partitionPath).addInserts(count);
            this.globalStat.addInserts(count);
        }
    }

    public WorkloadStat getGlobalStat() {
        return this.globalStat;
    }

    public Set<String> getPartitionPaths() {
        return this.partitionPathStatMap.keySet();
    }

    public WorkloadStat getWorkloadStat(String partitionPath) {
        return this.partitionPathStatMap.get(partitionPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WorkloadProfile {");
        sb.append("globalStat=").append(this.globalStat).append(", ");
        sb.append("partitionStat=").append(this.partitionPathStatMap);
        sb.append('}');
        return sb.toString();
    }
}

