/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import io.javalin.Context;
import io.javalin.Handler;
import io.javalin.Javalin;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.SyncableFileSystemView;
import org.apache.hudi.common.table.timeline.dto.BaseFileDTO;
import org.apache.hudi.common.table.timeline.dto.CompactionOpDTO;
import org.apache.hudi.common.table.timeline.dto.FileGroupDTO;
import org.apache.hudi.common.table.timeline.dto.FileSliceDTO;
import org.apache.hudi.common.table.timeline.dto.InstantDTO;
import org.apache.hudi.common.table.timeline.dto.TimelineDTO;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.RemoteHoodieTableFileSystemView;
import org.apache.hudi.timeline.service.handlers.BaseFileHandler;
import org.apache.hudi.timeline.service.handlers.FileSliceHandler;
import org.apache.hudi.timeline.service.handlers.TimelineHandler;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FileSystemViewHandler {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger LOG = LogManager.getLogger(FileSystemViewHandler.class);
    private final FileSystemViewManager viewManager;
    private final Javalin app;
    private final TimelineHandler instantHandler;
    private final FileSliceHandler sliceHandler;
    private final BaseFileHandler dataFileHandler;

    public FileSystemViewHandler(Javalin app, Configuration conf, FileSystemViewManager viewManager) throws IOException {
        this.viewManager = viewManager;
        this.app = app;
        this.instantHandler = new TimelineHandler(conf, viewManager);
        this.sliceHandler = new FileSliceHandler(conf, viewManager);
        this.dataFileHandler = new BaseFileHandler(conf, viewManager);
    }

    public void register() {
        this.registerDataFilesAPI();
        this.registerFileSlicesAPI();
        this.registerTimelineAPI();
    }

    private boolean isLocalViewBehind(Context ctx) {
        String basePath = ctx.queryParam("basepath");
        String lastKnownInstantFromClient = ctx.queryParam("lastinstantts", "0");
        String timelineHashFromClient = ctx.queryParam("timelinehash", "");
        HoodieTimeline localTimeline = this.viewManager.getFileSystemView(basePath).getTimeline().filterCompletedAndCompactionInstants();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Client [ LastTs=" + lastKnownInstantFromClient + ", TimelineHash=" + timelineHashFromClient + "], localTimeline=" + localTimeline.getInstants().collect(Collectors.toList())));
        }
        if (localTimeline.getInstants().count() == 0L && "0".equals(lastKnownInstantFromClient)) {
            return false;
        }
        String localTimelineHash = localTimeline.getTimelineHash();
        if (!localTimelineHash.equals(timelineHashFromClient)) {
            return true;
        }
        return !localTimeline.containsOrBeforeTimelineStarts(lastKnownInstantFromClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncIfLocalViewBehind(Context ctx) {
        if (this.isLocalViewBehind(ctx)) {
            SyncableFileSystemView view;
            String basePath = ctx.queryParam("basepath");
            String lastKnownInstantFromClient = ctx.queryParam("lastinstantts", "0");
            SyncableFileSystemView syncableFileSystemView = view = this.viewManager.getFileSystemView(basePath);
            synchronized (syncableFileSystemView) {
                if (this.isLocalViewBehind(ctx)) {
                    HoodieTimeline localTimeline = this.viewManager.getFileSystemView(basePath).getTimeline();
                    LOG.warn((Object)("Syncing view as client passed last known instant " + lastKnownInstantFromClient + " as last known instant but server has the folling timeline :" + localTimeline.getInstants().collect(Collectors.toList())));
                    view.sync();
                    return true;
                }
            }
        }
        return false;
    }

    private void writeValueAsString(Context ctx, Object obj) throws JsonProcessingException {
        boolean prettyPrint = ctx.queryParam("pretty") != null;
        long beginJsonTs = System.currentTimeMillis();
        String result = prettyPrint ? OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(obj) : OBJECT_MAPPER.writeValueAsString(obj);
        long endJsonTs = System.currentTimeMillis();
        LOG.debug((Object)("Jsonify TimeTaken=" + (endJsonTs - beginJsonTs)));
        ctx.result(result);
    }

    private void registerTimelineAPI() {
        this.app.get(RemoteHoodieTableFileSystemView.LAST_INSTANT, new ViewHandler(ctx -> {
            List<InstantDTO> dtos = this.instantHandler.getLastInstant((String)ctx.validatedQueryParam("basepath").getValue());
            this.writeValueAsString(ctx, dtos);
        }, false));
        this.app.get(RemoteHoodieTableFileSystemView.TIMELINE, new ViewHandler(ctx -> {
            TimelineDTO dto = this.instantHandler.getTimeline((String)ctx.validatedQueryParam("basepath").getValue());
            this.writeValueAsString(ctx, dto);
        }, false));
    }

    private void registerDataFilesAPI() {
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_DATA_FILES_URL, new ViewHandler(ctx -> {
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFiles((String)ctx.validatedQueryParam("basepath").getOrThrow(), (String)ctx.validatedQueryParam("partition").getOrThrow());
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_DATA_FILE_URL, new ViewHandler(ctx -> {
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFile((String)ctx.validatedQueryParam("basepath").getOrThrow(), (String)ctx.validatedQueryParam("partition").getOrThrow(), (String)ctx.validatedQueryParam("fileid").getOrThrow());
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_ALL_DATA_FILES, new ViewHandler(ctx -> {
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFiles((String)ctx.validatedQueryParam("basepath").getOrThrow());
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_DATA_FILES_BEFORE_ON_INSTANT_URL, new ViewHandler(ctx -> {
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFilesBeforeOrOn((String)ctx.validatedQueryParam("basepath").getOrThrow(), (String)ctx.validatedQueryParam("partition").getOrThrow(), (String)ctx.validatedQueryParam("maxinstant").getOrThrow());
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_DATA_FILE_ON_INSTANT_URL, new ViewHandler(ctx -> {
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFileOn((String)ctx.validatedQueryParam("basepath").getOrThrow(), (String)ctx.validatedQueryParam("partition").getOrThrow(), ctx.queryParam("instant"), (String)ctx.validatedQueryParam("fileid").getOrThrow());
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_DATA_FILES, new ViewHandler(ctx -> {
            List<BaseFileDTO> dtos = this.dataFileHandler.getAllDataFiles((String)ctx.validatedQueryParam("basepath").getOrThrow(), (String)ctx.validatedQueryParam("partition").getOrThrow());
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_DATA_FILES_RANGE_INSTANT_URL, new ViewHandler(ctx -> {
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFilesInRange((String)ctx.validatedQueryParam("basepath").getOrThrow(), Arrays.asList(((String)ctx.validatedQueryParam("instants").getOrThrow()).split(",")));
            this.writeValueAsString(ctx, dtos);
        }, true));
    }

    private void registerFileSlicesAPI() {
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_SLICES_URL, new ViewHandler(ctx -> {
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestFileSlices((String)ctx.validatedQueryParam("basepath").getOrThrow(), (String)ctx.validatedQueryParam("partition").getOrThrow());
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_SLICE_URL, new ViewHandler(ctx -> {
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestFileSlice((String)ctx.validatedQueryParam("basepath").getOrThrow(), (String)ctx.validatedQueryParam("partition").getOrThrow(), (String)ctx.validatedQueryParam("fileid").getOrThrow());
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_UNCOMPACTED_SLICES_URL, new ViewHandler(ctx -> {
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestUnCompactedFileSlices((String)ctx.validatedQueryParam("basepath").getOrThrow(), (String)ctx.validatedQueryParam("partition").getOrThrow());
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_SLICES_URL, new ViewHandler(ctx -> {
            List<FileSliceDTO> dtos = this.sliceHandler.getAllFileSlices((String)ctx.validatedQueryParam("basepath").getOrThrow(), (String)ctx.validatedQueryParam("partition").getOrThrow());
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_SLICES_RANGE_INSTANT_URL, new ViewHandler(ctx -> {
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestFileSliceInRange((String)ctx.validatedQueryParam("basepath").getOrThrow(), Arrays.asList(((String)ctx.validatedQueryParam("instants").getOrThrow()).split(",")));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_SLICES_MERGED_BEFORE_ON_INSTANT_URL, new ViewHandler(ctx -> {
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestMergedFileSlicesBeforeOrOn((String)ctx.validatedQueryParam("basepath").getOrThrow(), (String)ctx.validatedQueryParam("partition").getOrThrow(), (String)ctx.validatedQueryParam("maxinstant").getOrThrow());
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_SLICES_BEFORE_ON_INSTANT_URL, new ViewHandler(ctx -> {
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestFileSlicesBeforeOrOn((String)ctx.validatedQueryParam("basepath").getOrThrow(), (String)ctx.validatedQueryParam("partition").getOrThrow(), (String)ctx.validatedQueryParam("maxinstant").getOrThrow(), Boolean.parseBoolean((String)ctx.validatedQueryParam("includependingcompaction").getOrThrow()));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.PENDING_COMPACTION_OPS, new ViewHandler(ctx -> {
            List<CompactionOpDTO> dtos = this.sliceHandler.getPendingCompactionOperations((String)ctx.validatedQueryParam("basepath").getOrThrow());
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_FILEGROUPS_FOR_PARTITION_URL, new ViewHandler(ctx -> {
            List<FileGroupDTO> dtos = this.sliceHandler.getAllFileGroups((String)ctx.validatedQueryParam("basepath").getOrThrow(), (String)ctx.validatedQueryParam("partition").getOrThrow());
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.post(RemoteHoodieTableFileSystemView.REFRESH_TABLE, new ViewHandler(ctx -> {
            boolean success = this.sliceHandler.refreshTable((String)ctx.validatedQueryParam("basepath").getOrThrow());
            this.writeValueAsString(ctx, success);
        }, false));
    }

    private static boolean isRefreshCheckDisabledInQuery(Context ctxt) {
        return Boolean.parseBoolean(ctxt.queryParam("refreshoff"));
    }

    private class ViewHandler
    implements Handler {
        private final Handler handler;
        private final boolean performRefreshCheck;

        ViewHandler(Handler handler, boolean performRefreshCheck) {
            this.handler = handler;
            this.performRefreshCheck = performRefreshCheck;
        }

        @Override
        public void handle(@NotNull Context context) throws Exception {
            boolean success = true;
            long beginTs = System.currentTimeMillis();
            boolean synced = false;
            boolean refreshCheck = this.performRefreshCheck && !FileSystemViewHandler.isRefreshCheckDisabledInQuery(context);
            long refreshCheckTimeTaken = 0L;
            long handleTimeTaken = 0L;
            long finalCheckTimeTaken = 0L;
            try {
                if (refreshCheck) {
                    long beginRefreshCheck = System.currentTimeMillis();
                    synced = FileSystemViewHandler.this.syncIfLocalViewBehind(context);
                    long endRefreshCheck = System.currentTimeMillis();
                    refreshCheckTimeTaken = endRefreshCheck - beginRefreshCheck;
                }
                long handleBeginMs = System.currentTimeMillis();
                this.handler.handle(context);
                long handleEndMs = System.currentTimeMillis();
                handleTimeTaken = handleEndMs - handleBeginMs;
                if (refreshCheck) {
                    long beginFinalCheck = System.currentTimeMillis();
                    String errMsg = "Last known instant from client was " + context.queryParam("lastinstantts", "0") + " but server has the following timeline " + FileSystemViewHandler.this.viewManager.getFileSystemView(context.queryParam("basepath")).getTimeline().getInstants().collect(Collectors.toList());
                    Preconditions.checkArgument((!FileSystemViewHandler.this.isLocalViewBehind(context) ? 1 : 0) != 0, (Object)errMsg);
                    long endFinalCheck = System.currentTimeMillis();
                    finalCheckTimeTaken = endFinalCheck - beginFinalCheck;
                }
            }
            catch (RuntimeException re) {
                try {
                    success = false;
                    LOG.error((Object)("Got runtime exception servicing request " + context.queryString()), (Throwable)re);
                    throw re;
                }
                catch (Throwable throwable) {
                    long endTs = System.currentTimeMillis();
                    long timeTakenMillis = endTs - beginTs;
                    LOG.info((Object)String.format("TimeTakenMillis[Total=%d, Refresh=%d, handle=%d, Check=%d], Success=%s, Query=%s, Host=%s, synced=%s", timeTakenMillis, refreshCheckTimeTaken, handleTimeTaken, finalCheckTimeTaken, success, context.queryString(), context.host(), synced));
                    throw throwable;
                }
            }
            long endTs = System.currentTimeMillis();
            long timeTakenMillis = endTs - beginTs;
            LOG.info((Object)String.format("TimeTakenMillis[Total=%d, Refresh=%d, handle=%d, Check=%d], Success=%s, Query=%s, Host=%s, synced=%s", timeTakenMillis, refreshCheckTimeTaken, handleTimeTaken, finalCheckTimeTaken, success, context.queryString(), context.host(), synced));
        }
    }
}

