/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service;

import io.javalin.Javalin;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.com.beust.jcommander.JCommander;
import org.apache.hudi.com.beust.jcommander.Parameter;
import org.apache.hudi.common.SerializableConfiguration;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.timeline.service.FileSystemViewHandler;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TimelineService {
    private static final Logger LOG = LogManager.getLogger(TimelineService.class);
    private int serverPort;
    private Configuration conf;
    private transient FileSystem fs;
    private transient Javalin app = null;
    private transient FileSystemViewManager fsViewsManager;

    public int getServerPort() {
        return this.serverPort;
    }

    public TimelineService(int serverPort, FileSystemViewManager globalFileSystemViewManager, Configuration conf) throws IOException {
        this.conf = FSUtils.prepareHadoopConf(conf);
        this.fs = FileSystem.get((Configuration)conf);
        this.serverPort = serverPort;
        this.fsViewsManager = globalFileSystemViewManager;
    }

    public TimelineService(int serverPort, FileSystemViewManager globalFileSystemViewManager) throws IOException {
        this(serverPort, globalFileSystemViewManager, new Configuration());
    }

    public TimelineService(Config config) throws IOException {
        this(config.serverPort, TimelineService.buildFileSystemViewManager(config, new SerializableConfiguration(FSUtils.prepareHadoopConf(new Configuration()))));
    }

    public int startService() throws IOException {
        this.app = Javalin.create();
        FileSystemViewHandler router = new FileSystemViewHandler(this.app, this.conf, this.fsViewsManager);
        this.app.get("/", ctx -> ctx.result("Hello World"));
        router.register();
        this.app.start(this.serverPort);
        this.serverPort = this.app.port();
        LOG.info((Object)("Starting Timeline server on port :" + this.serverPort));
        return this.serverPort;
    }

    public void run() throws IOException {
        this.startService();
    }

    public static FileSystemViewManager buildFileSystemViewManager(Config config, SerializableConfiguration conf) {
        switch (config.viewStorageType) {
            case MEMORY: {
                FileSystemViewStorageConfig.Builder inMemConfBuilder = FileSystemViewStorageConfig.newBuilder();
                inMemConfBuilder.withStorageType(FileSystemViewStorageType.MEMORY);
                return FileSystemViewManager.createViewManager(conf, inMemConfBuilder.build());
            }
            case SPILLABLE_DISK: {
                FileSystemViewStorageConfig.Builder spillableConfBuilder = FileSystemViewStorageConfig.newBuilder();
                spillableConfBuilder.withStorageType(FileSystemViewStorageType.SPILLABLE_DISK).withBaseStoreDir(config.baseStorePathForFileGroups).withMaxMemoryForView((long)(config.maxViewMemPerTableInMB * 1024) * 1024L).withMemFractionForPendingCompaction(config.memFractionForCompactionPerTable);
                return FileSystemViewManager.createViewManager(conf, spillableConfBuilder.build());
            }
            case EMBEDDED_KV_STORE: {
                FileSystemViewStorageConfig.Builder rocksDBConfBuilder = FileSystemViewStorageConfig.newBuilder();
                rocksDBConfBuilder.withStorageType(FileSystemViewStorageType.EMBEDDED_KV_STORE).withRocksDBPath(config.rocksDBPath);
                return FileSystemViewManager.createViewManager(conf, rocksDBConfBuilder.build());
            }
        }
        throw new IllegalArgumentException("Invalid view manager storage type :" + (Object)((Object)config.viewStorageType));
    }

    public void close() {
        LOG.info((Object)"Closing Timeline Service");
        this.app.stop();
        this.app = null;
        this.fsViewsManager.close();
        LOG.info((Object)"Closed Timeline Service");
    }

    public Configuration getConf() {
        return this.conf;
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public static void main(String[] args) throws Exception {
        Config cfg = new Config();
        JCommander cmd = new JCommander((Object)cfg, null, args);
        if (cfg.help.booleanValue()) {
            cmd.usage();
            System.exit(1);
        }
        Configuration conf = FSUtils.prepareHadoopConf(new Configuration());
        FileSystemViewManager viewManager = TimelineService.buildFileSystemViewManager(cfg, new SerializableConfiguration(conf));
        TimelineService service2 = new TimelineService(cfg.serverPort, viewManager);
        service2.run();
    }

    public static class Config
    implements Serializable {
        @Parameter(names={"--server-port", "-p"}, description=" Server Port")
        public Integer serverPort = 26754;
        @Parameter(names={"--view-storage", "-st"}, description="View Storage Type. Default - SPILLABLE_DISK")
        public FileSystemViewStorageType viewStorageType = FileSystemViewStorageType.SPILLABLE_DISK;
        @Parameter(names={"--max-view-mem-per-table", "-mv"}, description="Maximum view memory per table in MB to be used for storing file-groups. Overflow file-groups will be spilled to disk. Used for SPILLABLE_DISK storage type")
        public Integer maxViewMemPerTableInMB = 2048;
        @Parameter(names={"--mem-overhead-fraction-pending-compaction", "-cf"}, description="Memory Fraction of --max-view-mem-per-table to be allocated for managing pending compaction storage. Overflow entries will be spilled to disk. Used for SPILLABLE_DISK storage type")
        public Double memFractionForCompactionPerTable = 0.001;
        @Parameter(names={"--base-store-path", "-sp"}, description="Directory where spilled view entries will be stored. Used for SPILLABLE_DISK storage type")
        public String baseStorePathForFileGroups = "/tmp/view_map/";
        @Parameter(names={"--rocksdb-path", "-rp"}, description="Root directory for RocksDB")
        public String rocksDBPath = "/tmp/hoodie_timeline_rocksdb";
        @Parameter(names={"--help", "-h"})
        public Boolean help = false;
    }
}

