/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;

public class UpgradeResponseAdapter
implements UpgradeResponse {
    public static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    private int statusCode;
    private String statusReason;
    private Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
    private boolean success = false;

    @Override
    public void addHeader(String name, String value) {
        String key = name;
        List<String> values2 = this.headers.get(key);
        if (values2 == null) {
            values2 = new ArrayList<String>();
        }
        values2.add(value);
        this.headers.put(key, values2);
    }

    @Override
    public String getAcceptedSubProtocol() {
        return this.getHeader(SEC_WEBSOCKET_PROTOCOL);
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getHeader(String name) {
        List<String> values2 = this.getHeaders(name);
        if (values2 == null) {
            return null;
        }
        int size = values2.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            return values2.get(0);
        }
        boolean needsDelim = false;
        StringBuilder ret = new StringBuilder();
        for (String value : values2) {
            if (needsDelim) {
                ret.append(", ");
            }
            QuoteUtil.quoteIfNeeded(ret, value, "\"'\\\n\r\t\f\b%+ ;=");
            needsDelim = true;
        }
        return ret.toString();
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.headers.get(name);
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getStatusReason() {
        return this.statusReason;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public void sendForbidden(String message) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setAcceptedSubProtocol(String protocol) {
        this.setHeader(SEC_WEBSOCKET_PROTOCOL, protocol);
    }

    @Override
    public void setExtensions(List<ExtensionConfig> extensions) {
        this.extensions.clear();
        if (extensions != null) {
            this.extensions.addAll(extensions);
        }
    }

    @Override
    public void setHeader(String name, String value) {
        ArrayList<String> values2 = new ArrayList<String>();
        values2.add(value);
        this.headers.put(name, values2);
    }

    @Override
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    @Override
    public void setSuccess(boolean success) {
        this.success = success;
    }
}

