/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hudi.spark.com.google.common.base.Preconditions;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FirstKeyOnlyFilter
extends FilterBase {
    private boolean foundKV = false;

    @Override
    public void reset() {
        this.foundKV = false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        if (this.foundKV) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        this.foundKV = true;
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public Cell transformCell(Cell v) {
        return v;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 0, "Expected 0 but got: %s", filterArguments.size());
        return new FirstKeyOnlyFilter();
    }

    protected boolean hasFoundKV() {
        return this.foundKV;
    }

    protected void setFoundKV(boolean value) {
        this.foundKV = value;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.FirstKeyOnlyFilter.Builder builder = FilterProtos.FirstKeyOnlyFilter.newBuilder();
        return builder.build().toByteArray();
    }

    public static FirstKeyOnlyFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            FilterProtos.FirstKeyOnlyFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new FirstKeyOnlyFilter();
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        return o instanceof FirstKeyOnlyFilter;
    }
}

