/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.mapred.TableInputFormatBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TableInputFormat
extends TableInputFormatBase
implements JobConfigurable {
    private static final Log LOG = LogFactory.getLog(TableInputFormat.class);
    public static final String COLUMN_LIST = "hbase.mapred.tablecolumns";

    public void configure(JobConf job) {
        try {
            this.initialize(job);
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
        }
    }

    @Override
    protected void initialize(JobConf job) throws IOException {
        Path[] tableNames = FileInputFormat.getInputPaths((JobConf)job);
        String colArg = job.get(COLUMN_LIST);
        String[] colNames = colArg.split(" ");
        byte[][] m_cols = new byte[colNames.length][];
        for (int i = 0; i < m_cols.length; ++i) {
            m_cols[i] = Bytes.toBytes(colNames[i]);
        }
        this.setInputColumns(m_cols);
        Connection connection = ConnectionFactory.createConnection((Configuration)job);
        this.initializeTable(connection, TableName.valueOf(tableNames[0].getName()));
    }

    public void validateInput(JobConf job) throws IOException {
        Path[] tableNames = FileInputFormat.getInputPaths((JobConf)job);
        if (tableNames == null || tableNames.length > 1) {
            throw new IOException("expecting one table name");
        }
        if (this.getHTable() == null) {
            throw new IOException("could not connect to table '" + tableNames[0].getName() + "'");
        }
        String colArg = job.get(COLUMN_LIST);
        if (colArg == null || colArg.length() == 0) {
            throw new IOException("expecting at least one column");
        }
    }
}

