/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieBootstrapRelation;
import org.apache.hudi.HoodieEmptyRelation;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.HoodieStreamingSink;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.IncrementalRelation;
import org.apache.hudi.MergeOnReadIncrementalRelation;
import org.apache.hudi.MergeOnReadSnapshotRelation;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.HoodieROTablePathFilter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.sources.StreamSinkProvider;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001%\u0011Q\u0002R3gCVdGoU8ve\u000e,'BA\u0002\u0005\u0003\u0011AW\u000fZ5\u000b\u0005\u00151\u0011AB1qC\u000eDWMC\u0001\b\u0003\ry'oZ\u0002\u0001'!\u0001!\u0002\u0005\u000e\u001eA\r2\u0003CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0005\u0002\u001215\t!C\u0003\u0002\u0014)\u000591o\\;sG\u0016\u001c(BA\u000b\u0017\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003/\u0011\tQa\u001d9be.L!!\u0007\n\u0003!I+G.\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\bCA\t\u001c\u0013\ta\"C\u0001\fTG\",W.\u0019*fY\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s!\t\tb$\u0003\u0002 %\tI2I]3bi\u0006\u0014G.\u001a*fY\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s!\t\t\u0012%\u0003\u0002#%\t\u0011B)\u0019;b'>,(oY3SK\u001eL7\u000f^3s!\t\tB%\u0003\u0002&%\t\u00112\u000b\u001e:fC6\u001c\u0016N\\6Qe>4\u0018\u000eZ3s!\tYq%\u0003\u0002)\u0019\ta1+\u001a:jC2L'0\u00192mK\")!\u0006\u0001C\u0001W\u00051A(\u001b8jiz\"\u0012\u0001\f\t\u0003[\u0001i\u0011A\u0001\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0003\rawnZ\u000b\u0002cA\u0011!'N\u0007\u0002g)\u0011A\u0007B\u0001\u0006Y><GG[\u0005\u0003mM\u0012a\u0001T8hO\u0016\u0014\bB\u0002\u001d\u0001A\u0003%\u0011'\u0001\u0003m_\u001e\u0004\u0003\"\u0002\u001e\u0001\t\u0003Z\u0014AD2sK\u0006$XMU3mCRLwN\u001c\u000b\u0004y}*\u0005CA\t>\u0013\tq$C\u0001\u0007CCN,'+\u001a7bi&|g\u000eC\u0003As\u0001\u0007\u0011)\u0001\u0006tc2\u001cuN\u001c;fqR\u0004\"AQ\"\u000e\u0003QI!\u0001\u0012\u000b\u0003\u0015M\u000bFjQ8oi\u0016DH\u000fC\u0003Gs\u0001\u0007q)\u0001\u0006qCJ\fW.\u001a;feN\u0004B\u0001S&O\u001d:\u00111\"S\u0005\u0003\u00152\ta\u0001\u0015:fI\u00164\u0017B\u0001'N\u0005\ri\u0015\r\u001d\u0006\u0003\u00152\u0001\"\u0001S(\n\u0005Ak%AB*ue&tw\rC\u0003;\u0001\u0011\u0005#\u000b\u0006\u0003='R3\u0006\"\u0002!R\u0001\u0004\t\u0005\"B+R\u0001\u00049\u0015!C8qiB\u000b'/Y7t\u0011\u00159\u0016\u000b1\u0001Y\u0003\u0019\u00198\r[3nCB\u0011\u0011\fX\u0007\u00025*\u00111\fF\u0001\u0006if\u0004Xm]\u0005\u0003;j\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015Q\u0004\u0001\"\u0011`)\u0015a\u0004-\u00194h\u0011\u0015\u0001e\f1\u0001B\u0011\u0015\u0011g\f1\u0001d\u0003\u0011iw\u000eZ3\u0011\u0005\t#\u0017BA3\u0015\u0005!\u0019\u0016M^3N_\u0012,\u0007\"B+_\u0001\u00049\u0005\"\u00025_\u0001\u0004I\u0017A\u00013g!\tQ\u0007P\u0004\u0002lm:\u0011A.\u001e\b\u0003[Rt!A\\:\u000f\u0005=\u0014X\"\u00019\u000b\u0005ED\u0011A\u0002\u001fs_>$h(C\u0001\b\u0013\t)a!\u0003\u0002\u0018\t%\u0011QCF\u0005\u0003oR\tq\u0001]1dW\u0006<W-\u0003\u0002zu\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003oRAQ\u0001 \u0001\u0005Bu\f!b\u0019:fCR,7+\u001b8l)%q\u0018QBA\b\u0003#\t)\u0003E\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\ngR\u0014X-Y7j]\u001eT1!a\u0002\u0015\u0003%)\u00070Z2vi&|g.\u0003\u0003\u0002\f\u0005\u0005!\u0001B*j].DQ\u0001Q>A\u0002\u0005CQ!V>A\u0002\u001dCq!a\u0005|\u0001\u0004\t)\"\u0001\tqCJ$\u0018\u000e^5p]\u000e{G.^7ogB)\u0011qCA\u0010\u001d:!\u0011\u0011DA\u000f\u001d\ry\u00171D\u0005\u0002\u001b%\u0011q\u000fD\u0005\u0005\u0003C\t\u0019CA\u0002TKFT!a\u001e\u0007\t\u000f\u0005\u001d2\u00101\u0001\u0002*\u0005Qq.\u001e;qkRlu\u000eZ3\u0011\t\u0005-\u0012qF\u0007\u0003\u0003[Q1!a\u0001\u0015\u0013\u0011\t\t$!\f\u0003\u0015=+H\u000f];u\u001b>$W\rC\u0004\u00026\u0001!\t%a\u000e\u0002\u0013MDwN\u001d;OC6,G#\u0001(\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>\u0005\u0019r-\u001a;CCN,g)\u001b7f\u001f:d\u0017PV5foRyA(a\u0010\u0002B\u0005\r\u0013QIA%\u0003'\nI\u0007\u0003\u0004A\u0003s\u0001\r!\u0011\u0005\u0007+\u0006e\u0002\u0019A$\t\r]\u000bI\u00041\u0001Y\u0011!\t9%!\u000fA\u0002\u0005U\u0011AD3yiJ\f'+Z1e!\u0006$\bn\u001d\u0005\t\u0003\u0017\nI\u00041\u0001\u0002N\u0005\u0019\u0012n\u001d\"p_R\u001cHO]1qa\u0016$G+\u00192mKB\u00191\"a\u0014\n\u0007\u0005ECBA\u0004C_>dW-\u00198\t\u0011\u0005U\u0013\u0011\ba\u0001\u0003/\n\u0011b\u001a7pEB\u000bG\u000f[:\u0011\r\u0005]\u0011qDA-!\u0011\tY&!\u001a\u000e\u0005\u0005u#\u0002BA0\u0003C\n!AZ:\u000b\u0007\u0005\rD!\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003O\niF\u0001\u0003QCRD\u0007\u0002CA6\u0003s\u0001\r!!\u001c\u0002\u00155,G/Y\"mS\u0016tG\u000f\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u000bQ\f'\r\\3\u000b\u0007\u0005]$!\u0001\u0004d_6lwN\\\u0005\u0005\u0003w\n\tHA\u000bI_>$\u0017.\u001a+bE2,W*\u001a;b\u00072LWM\u001c;")
public class DefaultSource
implements RelationProvider,
SchemaRelationProvider,
CreatableRelationProvider,
DataSourceRegister,
StreamSinkProvider,
Serializable {
    private final Logger log = LogManager.getLogger(DefaultSource.class);

    private Logger log() {
        return this.log;
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        return this.createRelation(sqlContext, parameters, null);
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> optParams, StructType schema) {
        Map<String, String> parameters;
        block11: {
            BaseRelation baseRelation;
            block9: {
                String tablePath;
                FileSystem fs;
                block10: {
                    boolean isBootstrappedTable;
                    HoodieTableMetaClient metaClient;
                    Seq<Path> globPaths;
                    Seq readPaths;
                    block8: {
                        parameters = DataSourceReadOptions$.MODULE$.translateViewTypesToQueryTypes(optParams);
                        scala.Option path = parameters.get((Object)"path");
                        scala.Option readPathsStr = parameters.get((Object)DataSourceReadOptions$.MODULE$.READ_PATHS_OPT_KEY());
                        if (path.isEmpty() && readPathsStr.isEmpty()) {
                            throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'path' or '", "' or both must be specified."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceReadOptions$.MODULE$.READ_PATHS_OPT_KEY()})));
                        }
                        readPaths = (Seq)readPathsStr.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<String> apply(String p) {
                                return Predef$.MODULE$.refArrayOps((Object[])p.split(",")).toSeq();
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<Nothing$> apply() {
                                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                            }
                        });
                        Seq allPaths = (Seq)((TraversableLike)path.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<String> apply(String p) {
                                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{p}));
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<Nothing$> apply() {
                                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                            }
                        })).$plus$plus((GenTraversableOnce)readPaths, Seq$.MODULE$.canBuildFrom());
                        fs = FSUtils.getFs((String)allPaths.head(), sqlContext.sparkContext().hadoopConfiguration());
                        globPaths = HoodieSparkUtils$.MODULE$.checkAndGlobPathIfNecessary((Seq<String>)allPaths, fs);
                        tablePath = DataSourceUtils.getTablePath(fs, (Path[])globPaths.toArray(ClassTag$.MODULE$.apply(Path.class)));
                        this.log().info((Object)new StringBuilder().append((Object)"Obtained hudi table path: ").append((Object)tablePath).toString());
                        metaClient = new HoodieTableMetaClient(fs.getConf(), tablePath);
                        isBootstrappedTable = metaClient.getTableConfig().getBootstrapBasePath().isPresent();
                        this.log().info((Object)new StringBuilder().append((Object)"Is bootstrapped table => ").append((Object)BoxesRunTime.boxToBoolean((boolean)isBootstrappedTable)).toString());
                        if (!((String)parameters.apply((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_OPT_KEY())).equals(DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL())) break block8;
                        if (metaClient.getTableType().equals((Object)HoodieTableType.MERGE_ON_READ)) {
                            if (isBootstrappedTable) {
                                this.log().warn((Object)"Snapshot query is not supported for Bootstrapped Merge-on-Read tables. Falling back to Read Optimized query.");
                                baseRelation = new HoodieBootstrapRelation(sqlContext, schema, globPaths, metaClient, optParams);
                            } else {
                                baseRelation = new MergeOnReadSnapshotRelation(sqlContext, optParams, schema, globPaths, metaClient);
                            }
                        } else {
                            baseRelation = this.getBaseFileOnlyView(sqlContext, parameters, schema, (Seq<String>)readPaths, isBootstrappedTable, globPaths, metaClient);
                        }
                        break block9;
                    }
                    if (!((String)parameters.apply((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_OPT_KEY())).equals(DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL())) break block10;
                    baseRelation = this.getBaseFileOnlyView(sqlContext, parameters, schema, (Seq<String>)readPaths, isBootstrappedTable, globPaths, metaClient);
                    break block9;
                }
                if (!((String)parameters.apply((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_OPT_KEY())).equals(DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL())) break block11;
                HoodieTableMetaClient metaClient = new HoodieTableMetaClient(fs.getConf(), tablePath);
                baseRelation = metaClient.getTableType().equals((Object)HoodieTableType.MERGE_ON_READ) ? new MergeOnReadIncrementalRelation(sqlContext, optParams, schema, metaClient) : new IncrementalRelation(sqlContext, optParams, schema, metaClient);
            }
            return baseRelation;
        }
        throw new HoodieException(new StringBuilder().append((Object)"Invalid query type :").append(parameters.apply((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_OPT_KEY())).toString());
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> optParams, Dataset<Row> df) {
        Map<String, String> parameters = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(optParams);
        Dataset dfWithoutMetaCols = df.drop((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala());
        Tuple5<Object, Option<String>, Option<String>, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, HoodieTableConfig> tuple5 = ((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.OPERATION_OPT_KEY())).equals(DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()) ? BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.MODULE$.bootstrap(sqlContext, mode, parameters, (Dataset<Row>)dfWithoutMetaCols, HoodieSparkSqlWriter$.MODULE$.bootstrap$default$5(), HoodieSparkSqlWriter$.MODULE$.bootstrap$default$6())) : HoodieSparkSqlWriter$.MODULE$.write(sqlContext, mode, parameters, (Dataset<Row>)dfWithoutMetaCols, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7());
        return new HoodieEmptyRelation(sqlContext, dfWithoutMetaCols.schema());
    }

    public Sink createSink(SQLContext sqlContext, Map<String, String> optParams, Seq<String> partitionColumns, OutputMode outputMode) {
        Map<String, String> parameters = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(optParams);
        return new HoodieStreamingSink(sqlContext, parameters, partitionColumns, outputMode);
    }

    public String shortName() {
        return "hudi";
    }

    private BaseRelation getBaseFileOnlyView(SQLContext sqlContext, Map<String, String> optParams, StructType schema, Seq<String> extraReadPaths, boolean isBootstrappedTable, Seq<Path> globPaths, HoodieTableMetaClient metaClient) {
        HoodieBootstrapRelation hoodieBootstrapRelation;
        this.log().warn((Object)"Loading Base File Only View.");
        if (isBootstrappedTable) {
            hoodieBootstrapRelation = new HoodieBootstrapRelation(sqlContext, schema, globPaths, metaClient, optParams);
        } else {
            sqlContext.sparkContext().hadoopConfiguration().setClass("mapreduce.input.pathFilter.class", HoodieROTablePathFilter.class, PathFilter.class);
            this.log().info((Object)new StringBuilder().append((Object)"Constructing hoodie (as parquet) data source with options :").append(optParams).toString());
            SparkSession x$1 = sqlContext.sparkSession();
            Seq<String> x$2 = extraReadPaths;
            scala.Option x$3 = Option$.MODULE$.apply((Object)schema);
            String x$4 = "parquet";
            Map<String, String> x$5 = optParams;
            Seq x$6 = DataSource$.MODULE$.apply$default$5();
            scala.Option x$7 = DataSource$.MODULE$.apply$default$6();
            scala.Option x$8 = DataSource$.MODULE$.apply$default$8();
            DataSource qual$1 = new DataSource(x$1, x$4, x$2, x$3, x$6, x$7, x$5, x$8);
            boolean x$9 = qual$1.resolveRelation$default$1();
            hoodieBootstrapRelation = qual$1.resolveRelation(x$9);
        }
        return hoodieBootstrapRelation;
    }
}

