/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.HashMap;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDatasetBulkInsertHelper;
import org.apache.hudi.HoodieSparkSqlWriter;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.sync.common.AbstractSyncTool;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class HoodieSparkSqlWriter$ {
    public static final HoodieSparkSqlWriter$ MODULE$;
    private final Logger org$apache$hudi$HoodieSparkSqlWriter$$log;
    private boolean tableExists;
    private boolean asyncCompactionTriggerFnDefined;

    static {
        new HoodieSparkSqlWriter$();
    }

    public Logger org$apache$hudi$HoodieSparkSqlWriter$$log() {
        return this.org$apache$hudi$HoodieSparkSqlWriter$$log;
    }

    private boolean tableExists() {
        return this.tableExists;
    }

    private void tableExists_$eq(boolean x$1) {
        this.tableExists = x$1;
    }

    private boolean asyncCompactionTriggerFnDefined() {
        return this.asyncCompactionTriggerFnDefined;
    }

    private void asyncCompactionTriggerFnDefined_$eq(boolean x$1) {
        this.asyncCompactionTriggerFnDefined = x$1;
    }

    public Tuple5<Object, Option<String>, Option<String>, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, HoodieTableConfig> write(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> parameters, Dataset<Row> df, scala.Option<HoodieTableConfig> hoodieTableConfigOpt, scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> hoodieWriteClient, scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>> asyncCompactionTriggerFn) {
        block13: {
            Tuple2<String, String> tuple2;
            block19: {
                Tuple2 tuple22;
                block20: {
                    Tuple2<Object, Option<String>> tuple23;
                    block21: {
                        Tuple5 tuple5;
                        block15: {
                            Tuple2 tuple24;
                            SparkRDDWriteClient writeClient;
                            String commitActionType;
                            HoodieTableConfig tableConfig;
                            String instantTime;
                            Path basePath;
                            JavaSparkContext jsc;
                            WriteOperationType operation;
                            block18: {
                                BoxedUnit boxedUnit;
                                JavaRDD<HoodieRecord> hoodieRecords;
                                Tuple2 tuple25;
                                Tuple2 tuple26;
                                String tblName;
                                scala.Option path;
                                SparkContext sparkContext;
                                block16: {
                                    block17: {
                                        FileSystem fs;
                                        HoodieTableType tableType;
                                        block14: {
                                            Some some;
                                            String ser;
                                            sparkContext = sqlContext.sparkContext();
                                            path = parameters.get((Object)"path");
                                            scala.Option tblNameOp = parameters.get((Object)"hoodie.table.name");
                                            this.asyncCompactionTriggerFnDefined_$eq(asyncCompactionTriggerFn.isDefined());
                                            if (path.isEmpty() || tblNameOp.isEmpty()) {
                                                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "', 'path' must be set."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hoodie.table.name"})));
                                            }
                                            tblName = ((String)tblNameOp.get()).trim();
                                            scala.Option option = sparkContext.getConf().getOption("spark.serializer");
                                            if (!(option instanceof Some) || !(ser = (String)(some = (Some)option).x()).equals("org.apache.spark.serializer.KryoSerializer")) break block13;
                                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                            tableType = HoodieTableType.valueOf((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE_OPT_KEY()));
                                            operation = WriteOperationType.fromValue((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.OPERATION_OPT_KEY()));
                                            if (new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS_OPT_KEY()))).toBoolean()) {
                                                WriteOperationType writeOperationType = operation;
                                                WriteOperationType writeOperationType2 = WriteOperationType.UPSERT;
                                                if (!(writeOperationType != null ? !((Object)((Object)writeOperationType)).equals((Object)writeOperationType2) : writeOperationType2 != null)) {
                                                    this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not applicable "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"when ", " is set to be true, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS_OPT_KEY()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"overriding the ", " to be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceWriteOptions$.MODULE$.OPERATION_OPT_KEY(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()}))).toString());
                                                    operation = WriteOperationType.INSERT;
                                                }
                                            }
                                            jsc = new JavaSparkContext(sparkContext);
                                            basePath = new Path((String)path.get());
                                            instantTime = HoodieActiveTimeline.createNewInstantTime();
                                            fs = basePath.getFileSystem(sparkContext.hadoopConfiguration());
                                            this.tableExists_$eq(fs.exists(new Path(basePath, ".hoodie")));
                                            tableConfig = this.getHoodieTableConfig(sparkContext, (String)path.get(), hoodieTableConfigOpt);
                                            SaveMode saveMode = mode;
                                            SaveMode saveMode2 = SaveMode.Ignore;
                                            if ((saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) || !this.tableExists()) break block14;
                                            this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists. Ignoring & not performing actual writes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
                                            tuple5 = new Tuple5((Object)BoxesRunTime.boxToBoolean((boolean)false), Option.empty(), Option.empty(), hoodieWriteClient.orNull(Predef$.MODULE$.$conforms()), (Object)tableConfig);
                                            break block15;
                                        }
                                        this.handleSaveModes(mode, basePath, tableConfig, tblName, operation, fs);
                                        if (!this.tableExists()) {
                                            String archiveLogFolder = (String)parameters.getOrElse((Object)"hoodie.archivelog.folder", (Function0)new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply() {
                                                    return "archived";
                                                }
                                            });
                                            HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.initTableType(sparkContext.hadoopConfiguration(), (String)path.get(), tableType, tblName, archiveLogFolder, (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_OPT_KEY()), null);
                                            tableConfig = tableMetaClient.getTableConfig();
                                        }
                                        commitActionType = DataSourceUtils.getCommitActionType(operation, tableConfig.getTableType());
                                        if (new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER_OPT_KEY()))).toBoolean()) {
                                            WriteOperationType writeOperationType = operation;
                                            WriteOperationType writeOperationType3 = WriteOperationType.BULK_INSERT;
                                            if (!(writeOperationType != null ? !((Object)((Object)writeOperationType)).equals((Object)writeOperationType3) : writeOperationType3 != null)) {
                                                Tuple2<Object, Option<String>> tuple27 = this.bulkInsertAsRow(sqlContext, parameters, df, tblName, basePath, (scala.Option<String>)path, instantTime);
                                                if (tuple27 != null) {
                                                    boolean success = tuple27._1$mcZ$sp();
                                                    Option commitTime = (Option)tuple27._2();
                                                    if (commitTime != null) {
                                                        Tuple2 tuple28;
                                                        Option option = commitTime;
                                                        Tuple2 tuple29 = tuple28 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)success), (Object)option);
                                                        boolean success2 = tuple29._1$mcZ$sp();
                                                        Option commitTime2 = (Option)tuple29._2();
                                                        return new Tuple5((Object)BoxesRunTime.boxToBoolean((boolean)success2), (Object)commitTime2, Option.empty(), hoodieWriteClient.orNull(Predef$.MODULE$.$conforms()), (Object)tableConfig);
                                                    }
                                                }
                                                throw new MatchError(tuple27);
                                            }
                                        }
                                        WriteOperationType writeOperationType = operation;
                                        WriteOperationType writeOperationType4 = WriteOperationType.DELETE;
                                        if (writeOperationType != null ? !((Object)((Object)writeOperationType)).equals((Object)writeOperationType4) : writeOperationType4 != null) break block16;
                                        String structName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_record"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tblName}));
                                        String nameSpace = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tblName}));
                                        sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
                                        KeyGenerator keyGenerator = DataSourceUtils.createKeyGenerator(this.toProperties(parameters));
                                        RDD<GenericRecord> genericRecords = HoodieSparkUtils$.MODULE$.createRdd(df, structName, nameSpace);
                                        JavaRDD hoodieKeysToDelete = genericRecords.map((Function1)new Serializable(keyGenerator){
                                            public static final long serialVersionUID = 0L;
                                            private final KeyGenerator keyGenerator$2;

                                            public final HoodieKey apply(GenericRecord gr) {
                                                return this.keyGenerator$2.getKey(gr);
                                            }
                                            {
                                                this.keyGenerator$2 = keyGenerator$2;
                                            }
                                        }, ClassTag$.MODULE$.apply(HoodieKey.class)).toJavaRDD();
                                        if (!this.tableExists()) break block17;
                                        SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0)new Serializable(parameters, path, tblName, jsc){
                                            public static final long serialVersionUID = 0L;
                                            private final scala.collection.immutable.Map parameters$2;
                                            private final scala.Option path$1;
                                            private final String tblName$1;
                                            private final JavaSparkContext jsc$1;

                                            public final SparkRDDWriteClient<HoodieRecordPayload> apply() {
                                                return DataSourceUtils.createHoodieClient(this.jsc$1, Schema.create((Schema.Type)Schema.Type.NULL).toString(), (String)this.path$1.get(), this.tblName$1, JavaConversions$.MODULE$.mapAsJavaMap(this.parameters$2.$minus((Object)"hoodie.auto.commit")));
                                            }
                                            {
                                                this.parameters$2 = parameters$2;
                                                this.path$1 = path$1;
                                                this.tblName$1 = tblName$1;
                                                this.jsc$1 = jsc$1;
                                            }
                                        });
                                        Object object = this.isAsyncCompactionEnabled(client, tableConfig, parameters, jsc.hadoopConfiguration()) ? ((Function1)asyncCompactionTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                                        client.startCommitWithTime(instantTime, commitActionType);
                                        HoodieWriteResult writeStatuses = DataSourceUtils.doDeleteOperation(client, (JavaRDD<HoodieKey>)hoodieKeysToDelete, instantTime);
                                        tuple26 = new Tuple2((Object)writeStatuses, (Object)client);
                                        break block18;
                                    }
                                    throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
                                }
                                tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tblName);
                                if (tuple2 == null) break block19;
                                String structName = (String)tuple2._1();
                                String nameSpace = (String)tuple2._2();
                                Tuple2 tuple210 = tuple25 = new Tuple2((Object)structName, (Object)nameSpace);
                                String structName2 = (String)tuple210._1();
                                String nameSpace2 = (String)tuple210._2();
                                sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
                                Schema schema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(df.schema(), structName2, nameSpace2);
                                sparkContext.getConf().registerAvroSchemas((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{schema}));
                                this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered avro schema : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema.toString(true)})));
                                KeyGenerator keyGenerator = DataSourceUtils.createKeyGenerator(this.toProperties(parameters));
                                RDD<GenericRecord> genericRecords = HoodieSparkUtils$.MODULE$.createRdd(df, schema, structName2, nameSpace2);
                                boolean shouldCombine = new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS_OPT_KEY()))).toBoolean() || operation.equals((Object)WriteOperationType.UPSERT);
                                JavaRDD<HoodieRecord> hoodieAllIncomingRecords = genericRecords.map((Function1)new Serializable(parameters, keyGenerator, shouldCombine){
                                    public static final long serialVersionUID = 0L;
                                    private final scala.collection.immutable.Map parameters$2;
                                    private final KeyGenerator keyGenerator$1;
                                    private final boolean shouldCombine$1;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final HoodieRecord<? extends HoodieRecordPayload<?>> apply(GenericRecord gr) {
                                        void var2_3;
                                        HoodieRecord hoodieRecord;
                                        if (this.shouldCombine$1) {
                                            Comparable orderingVal = (Comparable)HoodieAvroUtils.getNestedFieldVal(gr, (String)this.parameters$2.apply((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD_OPT_KEY()), false);
                                            hoodieRecord = DataSourceUtils.createHoodieRecord(gr, orderingVal, this.keyGenerator$1.getKey(gr), (String)this.parameters$2.apply((Object)DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_OPT_KEY()));
                                        } else {
                                            hoodieRecord = DataSourceUtils.createHoodieRecord(gr, this.keyGenerator$1.getKey(gr), (String)this.parameters$2.apply((Object)DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_OPT_KEY()));
                                        }
                                        HoodieRecord hoodieRecord2 = hoodieRecord;
                                        return var2_3;
                                    }
                                    {
                                        this.parameters$2 = parameters$2;
                                        this.keyGenerator$1 = keyGenerator$1;
                                        this.shouldCombine$1 = shouldCombine$1;
                                    }
                                }, ClassTag$.MODULE$.apply(HoodieRecord.class)).toJavaRDD();
                                SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0)new Serializable(parameters, path, tblName, jsc, schema){
                                    public static final long serialVersionUID = 0L;
                                    private final scala.collection.immutable.Map parameters$2;
                                    private final scala.Option path$1;
                                    private final String tblName$1;
                                    private final JavaSparkContext jsc$1;
                                    private final Schema schema$1;

                                    public final SparkRDDWriteClient<HoodieRecordPayload> apply() {
                                        return DataSourceUtils.createHoodieClient(this.jsc$1, this.schema$1.toString(), (String)this.path$1.get(), this.tblName$1, JavaConversions$.MODULE$.mapAsJavaMap(this.parameters$2.$minus((Object)"hoodie.auto.commit")));
                                    }
                                    {
                                        this.parameters$2 = parameters$2;
                                        this.path$1 = path$1;
                                        this.tblName$1 = tblName$1;
                                        this.jsc$1 = jsc$1;
                                        this.schema$1 = schema$1;
                                    }
                                });
                                Object object = this.isAsyncCompactionEnabled(client, tableConfig, parameters, jsc.hadoopConfiguration()) ? ((Function1)asyncCompactionTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                                JavaRDD<HoodieRecord> javaRDD = hoodieRecords = new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS_OPT_KEY()))).toBoolean() ? DataSourceUtils.dropDuplicates(jsc, hoodieAllIncomingRecords, JavaConversions$.MODULE$.mapAsJavaMap(parameters)) : hoodieAllIncomingRecords;
                                if (hoodieRecords.isEmpty()) {
                                    this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)"new batch has no new records, skipping...");
                                    boxedUnit = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), Option.empty());
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                client.startCommitWithTime(instantTime, commitActionType);
                                HoodieWriteResult writeResult = DataSourceUtils.doWriteOperation(client, hoodieRecords, instantTime, operation);
                                tuple26 = tuple22 = new Tuple2((Object)writeResult, (Object)client);
                            }
                            if (tuple22 == null) break block20;
                            HoodieWriteResult writeResult = (HoodieWriteResult)tuple22._1();
                            SparkRDDWriteClient writeClient2 = (SparkRDDWriteClient)tuple22._2();
                            if (writeClient2 == null) break block20;
                            SparkRDDWriteClient sparkRDDWriteClient = writeClient2;
                            Tuple2 tuple211 = new Tuple2((Object)writeResult, (Object)sparkRDDWriteClient);
                            Tuple2 tuple212 = tuple211;
                            HoodieWriteResult writeResult2 = (HoodieWriteResult)tuple212._1();
                            tuple23 = this.commitAndPerformPostOperations(writeResult2, parameters, writeClient = (SparkRDDWriteClient)tuple212._2(), tableConfig, jsc, new HoodieSparkSqlWriter.TableInstantInfo(basePath, instantTime, commitActionType, operation));
                            if (tuple23 == null) break block21;
                            boolean writeSuccessful = tuple23._1$mcZ$sp();
                            Option compactionInstant = (Option)tuple23._2();
                            Tuple2 tuple213 = tuple24 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)writeSuccessful), (Object)compactionInstant);
                            boolean writeSuccessful2 = tuple213._1$mcZ$sp();
                            Option compactionInstant2 = (Option)tuple213._2();
                            tuple5 = new Tuple5((Object)BoxesRunTime.boxToBoolean((boolean)writeSuccessful2), Option.ofNullable(instantTime), (Object)compactionInstant2, (Object)writeClient, (Object)tableConfig);
                        }
                        return tuple5;
                    }
                    throw new MatchError(tuple23);
                }
                throw new MatchError((Object)tuple22);
            }
            throw new MatchError(tuple2);
        }
        throw new HoodieException("hoodie only support org.apache.spark.serializer.KryoSerializer as spark.serializer");
    }

    public scala.Option<HoodieTableConfig> write$default$5() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> write$default$6() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>> write$default$7() {
        return Option$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean bootstrap(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> parameters, Dataset<Row> df, scala.Option<HoodieTableConfig> hoodieTableConfigOpt, scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> hoodieWriteClient) {
        Object object;
        Object object2;
        SparkContext sparkContext = sqlContext.sparkContext();
        String path = (String)parameters.getOrElse((Object)"path", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new HoodieException("'path' must be set.");
            }
        });
        String tableName = (String)parameters.getOrElse((Object)"hoodie.table.name", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' must be set."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hoodie.table.name"})));
            }
        });
        String tableType = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE_OPT_KEY());
        String bootstrapBasePath = (String)parameters.getOrElse((Object)"hoodie.bootstrap.base.path", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new HoodieException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is required for '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hoodie.bootstrap.base.path", DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()}))).append((Object)" operation'").toString());
            }
        });
        String bootstrapIndexClass = JavaConversions$.MODULE$.mapAsJavaMap(parameters).getOrDefault("hoodie.bootstrap.index.class", HoodieBootstrapConfig.DEFAULT_BOOTSTRAP_INDEX_CLASS);
        ObjectRef schema = ObjectRef.create(null);
        if (df.schema().nonEmpty()) {
            Tuple2 tuple2;
            Tuple2<String, String> tuple22 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tableName);
            if (tuple22 == null) throw new MatchError(tuple22);
            String structName = (String)tuple22._1();
            String namespace = (String)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)structName, (Object)namespace);
            String structName2 = (String)tuple23._1();
            String namespace2 = (String)tuple23._2();
            schema.elem = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(df.schema(), structName2, namespace2).toString();
        } else {
            schema.elem = HoodieAvroUtils.getNullSchema().toString();
        }
        Path basePath = new Path(path);
        FileSystem fs = basePath.getFileSystem(sparkContext.hadoopConfiguration());
        this.tableExists_$eq(fs.exists(new Path(basePath, ".hoodie")));
        HoodieTableConfig tableConfig = this.getHoodieTableConfig(sparkContext, path, hoodieTableConfigOpt);
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Ignore;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && this.tableExists()) {
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists. Ignoring & not performing actual writes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
            object2 = BoxesRunTime.boxToBoolean((boolean)false);
        } else {
            this.handleSaveModes(mode, basePath, tableConfig, tableName, WriteOperationType.BOOTSTRAP, fs);
            object2 = BoxedUnit.UNIT;
        }
        if (this.tableExists()) {
            object = BoxedUnit.UNIT;
        } else {
            String archiveLogFolder = (String)parameters.getOrElse((Object)"hoodie.archivelog.folder", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "archived";
                }
            });
            object = HoodieTableMetaClient.initTableTypeWithBootstrap(sparkContext.hadoopConfiguration(), path, HoodieTableType.valueOf(tableType), tableName, archiveLogFolder, (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_OPT_KEY()), null, bootstrapIndexClass, bootstrapBasePath);
        }
        JavaSparkContext jsc = new JavaSparkContext(sqlContext.sparkContext());
        SparkRDDWriteClient writeClient = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0)new Serializable(parameters, path, tableName, schema, jsc){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map parameters$1;
            private final String path$2;
            private final String tableName$1;
            private final ObjectRef schema$2;
            private final JavaSparkContext jsc$2;

            public final SparkRDDWriteClient<HoodieRecordPayload> apply() {
                return DataSourceUtils.createHoodieClient(this.jsc$2, (String)this.schema$2.elem, this.path$2, this.tableName$1, JavaConversions$.MODULE$.mapAsJavaMap((Map)this.parameters$1));
            }
            {
                this.parameters$1 = parameters$1;
                this.path$2 = path$2;
                this.tableName$1 = tableName$1;
                this.schema$2 = schema$2;
                this.jsc$2 = jsc$2;
            }
        });
        try {
            writeClient.bootstrap(Option.<java.util.Map<String, String>>empty());
        }
        catch (Throwable throwable) {
            void var27_27;
            var27_27.close();
            throw throwable;
        }
        writeClient.close();
        return this.metaSync(parameters, basePath, jsc.hadoopConfiguration());
    }

    public scala.Option<HoodieTableConfig> bootstrap$default$5() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> bootstrap$default$6() {
        return Option$.MODULE$.empty();
    }

    public Tuple2<Object, Option<String>> bulkInsertAsRow(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters, Dataset<Row> df, String tblName, Path basePath, scala.Option<String> path, String instantTime) {
        block4: {
            block3: {
                Dataset<Row> hoodieDF;
                block2: {
                    String structName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_record"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tblName}));
                    String nameSpace = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tblName}));
                    HoodieWriteConfig writeConfig = DataSourceUtils.createHoodieConfig(null, (String)path.get(), tblName, JavaConversions$.MODULE$.mapAsJavaMap(parameters));
                    hoodieDF = HoodieDatasetBulkInsertHelper.prepareHoodieDatasetForBulkInsert(sqlContext, writeConfig, df, structName, nameSpace);
                    if (!package$.MODULE$.SPARK_VERSION().startsWith("2.")) break block2;
                    hoodieDF.write().format("org.apache.hudi.internal").option("hoodie.instant.time", instantTime).options(parameters).save();
                    break block3;
                }
                if (!package$.MODULE$.SPARK_VERSION().startsWith("3.")) break block4;
                hoodieDF.write().format("org.apache.hudi.spark3.internal").option("hoodie.instant.time", instantTime).option("hoodie.bulkinsert.schema.ddl", hoodieDF.schema().toDDL()).options(parameters).mode(SaveMode.Append).save();
            }
            boolean hiveSyncEnabled = parameters.get((Object)DataSourceWriteOptions$.MODULE$.HIVE_SYNC_ENABLED_OPT_KEY()).exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String r) {
                    return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
                }
            });
            boolean metaSyncEnabled = parameters.get((Object)DataSourceWriteOptions$.MODULE$.META_SYNC_ENABLED_OPT_KEY()).exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String r) {
                    return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
                }
            });
            boolean syncHiveSucess = hiveSyncEnabled || metaSyncEnabled ? this.metaSync(parameters, basePath, sqlContext.sparkContext().hadoopConfiguration()) : true;
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)syncHiveSucess), Option.ofNullable(instantTime));
        }
        throw new HoodieException("Bulk insert using row writer is not supported with current Spark version. To use row writer please switch to spark 2 or spark 3");
    }

    /*
     * WARNING - void declaration
     */
    public TypedProperties toProperties(scala.collection.immutable.Map<String, String> params) {
        void var2_2;
        TypedProperties props = new TypedProperties();
        params.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final TypedProperties props$1;

            public final Object apply(Tuple2<String, String> kv) {
                return this.props$1.setProperty((String)kv._1(), (String)kv._2());
            }
            {
                this.props$1 = props$1;
            }
        });
        return var2_2;
    }

    private void handleSaveModes(SaveMode mode, Path tablePath, HoodieTableConfig tableConfig, String tableName, WriteOperationType operation, FileSystem fs) {
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Append;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null)) {
            String existingTableName;
            if (this.tableExists() && !(existingTableName = tableConfig.getTableName()).equals(tableName)) {
                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table with name ", " already exists at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{existingTableName, tablePath})));
            }
        }
        WriteOperationType writeOperationType = operation;
        WriteOperationType writeOperationType2 = WriteOperationType.DELETE;
        if (!(writeOperationType != null ? !((Object)((Object)writeOperationType)).equals((Object)writeOperationType2) : writeOperationType2 != null)) {
            SaveMode saveMode3 = mode;
            SaveMode saveMode4 = SaveMode.Append;
            if (saveMode3 == null ? saveMode4 != null : !saveMode3.equals(saveMode4)) {
                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Append is the only save mode applicable for ", " operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation.toString()})));
            }
        } else {
            SaveMode saveMode5 = mode;
            SaveMode saveMode6 = SaveMode.ErrorIfExists;
            if (!(saveMode5 != null ? !saveMode5.equals(saveMode6) : saveMode6 != null) && this.tableExists()) {
                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tablePath})));
            }
            SaveMode saveMode7 = mode;
            SaveMode saveMode8 = SaveMode.Overwrite;
            if (!(saveMode7 != null ? !saveMode7.equals(saveMode8) : saveMode8 != null) && this.tableExists()) {
                WriteOperationType writeOperationType3 = operation;
                WriteOperationType writeOperationType4 = WriteOperationType.INSERT_OVERWRITE_TABLE;
                if (writeOperationType3 == null ? writeOperationType4 != null : !((Object)((Object)writeOperationType3)).equals((Object)writeOperationType4)) {
                    this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists. Deleting existing data & overwriting with new data."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tablePath})));
                    fs.delete(tablePath, true);
                    this.tableExists_$eq(false);
                }
            }
        }
    }

    public boolean org$apache$hudi$HoodieSparkSqlWriter$$syncHive(Path basePath, FileSystem fs, scala.collection.immutable.Map<String, String> parameters) {
        HiveSyncConfig hiveSyncConfig = this.buildSyncConfig(basePath, parameters);
        HiveConf hiveConf = new HiveConf();
        hiveConf.addResource(fs.getConf());
        new HiveSyncTool(hiveSyncConfig, hiveConf, fs).syncHoodieTable();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private HiveSyncConfig buildSyncConfig(Path basePath, scala.collection.immutable.Map<String, String> parameters) {
        void var3_3;
        HiveSyncConfig hiveSyncConfig = new HiveSyncConfig();
        hiveSyncConfig.basePath = basePath.toString();
        hiveSyncConfig.baseFileFormat = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_BASE_FILE_FORMAT_OPT_KEY());
        hiveSyncConfig.usePreApacheInputFormat = Predef$.MODULE$.boolean2Boolean(parameters.get((Object)DataSourceWriteOptions$.MODULE$.HIVE_USE_PRE_APACHE_INPUT_FORMAT_OPT_KEY()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String r) {
                return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
            }
        }));
        hiveSyncConfig.databaseName = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_DATABASE_OPT_KEY());
        hiveSyncConfig.tableName = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_TABLE_OPT_KEY());
        hiveSyncConfig.hiveUser = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_USER_OPT_KEY());
        hiveSyncConfig.hivePass = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_PASS_OPT_KEY());
        hiveSyncConfig.jdbcUrl = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_URL_OPT_KEY());
        hiveSyncConfig.partitionFields = JavaConversions$.MODULE$.bufferAsJavaList((Buffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_PARTITION_FIELDS_OPT_KEY())).split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$6) {
                return x$6.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                return !x$7.isEmpty();
            }
        })).toList()));
        hiveSyncConfig.partitionValueExtractorClass = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_PARTITION_EXTRACTOR_CLASS_OPT_KEY());
        hiveSyncConfig.useJdbc = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_USE_JDBC_OPT_KEY()))).toBoolean());
        hiveSyncConfig.useFileListingFromMetadata = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)"hoodie.metadata.enable"))).toBoolean());
        hiveSyncConfig.verifyMetadataFileListing = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)"hoodie.metadata.validate"))).toBoolean());
        hiveSyncConfig.supportTimestamp = Predef$.MODULE$.boolean2Boolean(parameters.get((Object)DataSourceWriteOptions$.MODULE$.HIVE_SUPPORT_TIMESTAMP()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String r) {
                return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
            }
        }));
        hiveSyncConfig.autoCreateDatabase = Predef$.MODULE$.boolean2Boolean(parameters.get((Object)DataSourceWriteOptions$.MODULE$.HIVE_AUTO_CREATE_DATABASE_OPT_KEY()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String r) {
                return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
            }
        }));
        hiveSyncConfig.decodePartition = Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING_OPT_KEY(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return DataSourceWriteOptions$.MODULE$.DEFAULT_URL_ENCODE_PARTITIONING_OPT_VAL();
            }
        }))).toBoolean());
        return var3_3;
    }

    private boolean metaSync(scala.collection.immutable.Map<String, String> parameters, Path basePath, Configuration hadoopConf) {
        BoxedUnit boxedUnit;
        boolean hiveSyncEnabled = parameters.get((Object)DataSourceWriteOptions$.MODULE$.HIVE_SYNC_ENABLED_OPT_KEY()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String r) {
                return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
            }
        });
        boolean metaSyncEnabled = parameters.get((Object)DataSourceWriteOptions$.MODULE$.META_SYNC_ENABLED_OPT_KEY()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String r) {
                return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
            }
        });
        ObjectRef syncClientToolClassSet = ObjectRef.create((Object)((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Predef$.MODULE$.refArrayOps((Object[])((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.META_SYNC_CLIENT_TOOL_CLASS())).split(",")).foreach((Function1)new Serializable(syncClientToolClassSet){
            public static final long serialVersionUID = 0L;
            private final ObjectRef syncClientToolClassSet$1;

            public final Set<String> apply(String syncClass) {
                return (Set)((Set)this.syncClientToolClassSet$1.elem).$plus$eq((Object)syncClass);
            }
            {
                this.syncClientToolClassSet$1 = syncClientToolClassSet$1;
            }
        });
        if (hiveSyncEnabled) {
            metaSyncEnabled = true;
            boxedUnit = ((Set)syncClientToolClassSet.elem).$plus$eq((Object)HiveSyncTool.class.getName());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BooleanRef metaSyncSuccess = BooleanRef.create((boolean)true);
        if (metaSyncEnabled) {
            FileSystem fs = basePath.getFileSystem(hadoopConf);
            ((Set)syncClientToolClassSet.elem).foreach((Function1)new Serializable(parameters, basePath, metaSyncSuccess, fs){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map parameters$4;
                private final Path basePath$1;
                private final BooleanRef metaSyncSuccess$1;
                private final FileSystem fs$1;

                public final void apply(String impl) {
                    boolean bl;
                    String string = impl.trim();
                    if ("org.apache.hudi.hive.HiveSyncTool".equals(string)) {
                        HoodieSparkSqlWriter$.MODULE$.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringBuilder().append((Object)"Syncing to Hive Metastore (URL: ").append(this.parameters$4.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_URL_OPT_KEY())).append((Object)")").toString());
                        HoodieSparkSqlWriter$.MODULE$.org$apache$hudi$HoodieSparkSqlWriter$$syncHive(this.basePath$1, this.fs$1, (scala.collection.immutable.Map<String, String>)this.parameters$4);
                        bl = true;
                    } else {
                        Properties properties = new Properties();
                        properties.putAll((java.util.Map<?, ?>)JavaConversions$.MODULE$.mapAsJavaMap((Map)this.parameters$4));
                        properties.put("basePath", this.basePath$1.toString());
                        AbstractSyncTool syncHoodie = (AbstractSyncTool)ReflectionUtils.loadClass(impl.trim(), (Class[])((Object[])new Class[]{Properties.class, FileSystem.class}), new Object[]{properties, this.fs$1});
                        syncHoodie.syncHoodieTable();
                        bl = true;
                    }
                    boolean syncSuccess = bl;
                    this.metaSyncSuccess$1.elem = this.metaSyncSuccess$1.elem && syncSuccess;
                }
                {
                    this.parameters$4 = parameters$4;
                    this.basePath$1 = basePath$1;
                    this.metaSyncSuccess$1 = metaSyncSuccess$1;
                    this.fs$1 = fs$1;
                }
            });
        }
        return metaSyncSuccess.elem;
    }

    private Tuple2<Object, Option<String>> commitAndPerformPostOperations(HoodieWriteResult writeResult, scala.collection.immutable.Map<String, String> parameters, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>> client, HoodieTableConfig tableConfig, JavaSparkContext jsc, HoodieSparkSqlWriter.TableInstantInfo tableInstantInfo) {
        Tuple2 tuple2;
        long errorCount = writeResult.getWriteStatuses().rdd().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(WriteStatus ws) {
                return ws.hasErrors();
            }
        }).count();
        if (errorCount == 0L) {
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)"No errors. Proceeding to commit the write.");
            scala.collection.immutable.Map metaMap = (scala.collection.immutable.Map)parameters.filter((Function1)new Serializable(parameters){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map parameters$3;

                public final boolean apply(Tuple2<String, String> kv) {
                    return ((String)kv._1()).startsWith((String)this.parameters$3.apply((Object)DataSourceWriteOptions$.MODULE$.COMMIT_METADATA_KEYPREFIX_OPT_KEY()));
                }
                {
                    this.parameters$3 = parameters$3;
                }
            });
            boolean commitSuccess = client.commit(tableInstantInfo.instantTime(), writeResult.getWriteStatuses(), Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap))), tableInstantInfo.commitActionType(), writeResult.getPartitionToReplaceFileIds());
            if (commitSuccess) {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringBuilder().append((Object)"Commit ").append((Object)tableInstantInfo.instantTime()).append((Object)" successful!").toString());
            } else {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringBuilder().append((Object)"Commit ").append((Object)tableInstantInfo.instantTime()).append((Object)" failed!").toString());
            }
            boolean asyncCompactionEnabled = this.isAsyncCompactionEnabled(client, tableConfig, parameters, jsc.hadoopConfiguration());
            Option compactionInstant = asyncCompactionEnabled ? client.scheduleCompaction(Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap)))) : Option.empty();
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction Scheduled is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compactionInstant})));
            boolean metaSyncSuccess = this.metaSync(parameters, tableInstantInfo.basePath(), jsc.hadoopConfiguration());
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Is Async Compaction Enabled ? ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)asyncCompactionEnabled)})));
            if (!asyncCompactionEnabled) {
                client.close();
            }
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((commitSuccess && metaSyncSuccess ? 1 : 0) != 0), compactionInstant);
        } else {
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().error((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed with ", " errors :"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableInstantInfo.operation(), BoxesRunTime.boxToLong((long)errorCount)})));
            if (this.org$apache$hudi$HoodieSparkSqlWriter$$log().isTraceEnabled()) {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().trace((Object)"Printing out the top 100 errors");
                Predef$.MODULE$.refArrayOps((Object[])writeResult.getWriteStatuses().rdd().filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(WriteStatus ws) {
                        return ws.hasErrors();
                    }
                }).take(100)).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(WriteStatus ws) {
                        HoodieSparkSqlWriter$.MODULE$.org$apache$hudi$HoodieSparkSqlWriter$$log().trace((Object)"Global error :", ws.getGlobalError());
                        if (ws.getErrors().size() > 0) {
                            JavaConversions$.MODULE$.mapAsScalaMap(ws.getErrors()).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Tuple2<HoodieKey, Throwable> kt) {
                                    HoodieSparkSqlWriter$.MODULE$.org$apache$hudi$HoodieSparkSqlWriter$$log().trace((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error for key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kt._1()})), (Throwable)kt._2());
                                }
                            });
                        }
                    }
                });
            }
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), Option.empty());
        }
        return tuple2;
    }

    private boolean isAsyncCompactionEnabled(SparkRDDWriteClient<HoodieRecordPayload<Nothing$>> client, HoodieTableConfig tableConfig, scala.collection.immutable.Map<String, String> parameters, Configuration configuration) {
        boolean bl;
        this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Config.isInlineCompaction ? ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)client.getConfig().isInlineCompaction())})));
        if (this.asyncCompactionTriggerFnDefined() && !client.getConfig().isInlineCompaction() && parameters.get((Object)DataSourceWriteOptions$.MODULE$.ASYNC_COMPACT_ENABLE_OPT_KEY()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String r) {
                return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
            }
        })) {
            HoodieTableType hoodieTableType = tableConfig.getTableType();
            HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
            bl = !(hoodieTableType != null ? !((Object)((Object)hoodieTableType)).equals((Object)hoodieTableType2) : hoodieTableType2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    private HoodieTableConfig getHoodieTableConfig(SparkContext sparkContext, String tablePath, scala.Option<HoodieTableConfig> hoodieTableConfigOpt) {
        return this.tableExists() ? (HoodieTableConfig)hoodieTableConfigOpt.getOrElse((Function0)new Serializable(sparkContext, tablePath){
            public static final long serialVersionUID = 0L;
            private final SparkContext sparkContext$1;
            private final String tablePath$1;

            public final HoodieTableConfig apply() {
                return new HoodieTableMetaClient(this.sparkContext$1.hadoopConfiguration(), this.tablePath$1).getTableConfig();
            }
            {
                this.sparkContext$1 = sparkContext$1;
                this.tablePath$1 = tablePath$1;
            }
        }) : null;
    }

    private HoodieSparkSqlWriter$() {
        MODULE$ = this;
        this.org$apache$hudi$HoodieSparkSqlWriter$$log = LogManager.getLogger(this.getClass());
        this.tableExists = false;
        this.asyncCompactionTriggerFnDefined = false;
    }
}

