/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.client.embedded.EmbeddedTimelineServerHelper;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractHoodieClient
implements Serializable,
AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(AbstractHoodieClient.class);
    protected final transient FileSystem fs;
    protected final transient HoodieEngineContext context;
    protected final transient Configuration hadoopConf;
    protected final HoodieWriteConfig config;
    protected final String basePath;
    private transient Option<EmbeddedTimelineService> timelineServer;
    private final boolean shouldStopTimelineServer;

    protected AbstractHoodieClient(HoodieEngineContext context, HoodieWriteConfig clientConfig) {
        this(context, clientConfig, Option.empty());
    }

    protected AbstractHoodieClient(HoodieEngineContext context, HoodieWriteConfig clientConfig, Option<EmbeddedTimelineService> timelineServer) {
        this.hadoopConf = context.getHadoopConf().get();
        this.fs = FSUtils.getFs(clientConfig.getBasePath(), this.hadoopConf);
        this.context = context;
        this.basePath = clientConfig.getBasePath();
        this.config = clientConfig;
        this.timelineServer = timelineServer;
        this.shouldStopTimelineServer = !timelineServer.isPresent();
        this.startEmbeddedServerView();
        this.initWrapperFSMetrics();
    }

    @Override
    public void close() {
        this.stopEmbeddedServerView(true);
        this.context.setJobStatus("", "");
    }

    private synchronized void stopEmbeddedServerView(boolean resetViewStorageConfig) {
        if (this.timelineServer.isPresent() && this.shouldStopTimelineServer) {
            LOG.info((Object)"Stopping Timeline service !!");
            this.timelineServer.get().stop();
        }
        this.timelineServer = Option.empty();
        if (resetViewStorageConfig) {
            this.config.resetViewStorageConfig();
        }
    }

    private synchronized void startEmbeddedServerView() {
        if (this.config.isEmbeddedTimelineServerEnabled()) {
            if (!this.timelineServer.isPresent()) {
                try {
                    this.timelineServer = EmbeddedTimelineServerHelper.createEmbeddedTimelineService(this.context, this.config);
                }
                catch (IOException e) {
                    LOG.warn((Object)"Unable to start timeline service. Proceeding as if embedded server is disabled", (Throwable)e);
                    this.stopEmbeddedServerView(false);
                }
            } else {
                LOG.info((Object)"Timeline Server already running. Not restarting the service");
            }
        } else {
            LOG.info((Object)"Embedded Timeline Server is disabled. Not starting timeline service");
        }
    }

    public HoodieWriteConfig getConfig() {
        return this.config;
    }

    public HoodieEngineContext getEngineContext() {
        return this.context;
    }

    protected void initWrapperFSMetrics() {
    }

    protected HoodieTableMetaClient createMetaClient(boolean loadActiveTimelineOnLoad) {
        return new HoodieTableMetaClient(this.hadoopConf, this.config.getBasePath(), loadActiveTimelineOnLoad, this.config.getConsistencyGuardConfig(), Option.of(new TimelineLayoutVersion(this.config.getTimelineLayoutVersion())));
    }

    public Option<EmbeddedTimelineService> getTimelineServer() {
        return this.timelineServer;
    }
}

