/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.bootstrap;

import java.util.List;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.client.bootstrap.HoodieBootstrapSchemaProvider;
import org.apache.hudi.common.bootstrap.FileStatusUtils;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.spark.org.apache.spark.sql.avro.SchemaConverters;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;

public class HoodieSparkBootstrapSchemaProvider
extends HoodieBootstrapSchemaProvider {
    public HoodieSparkBootstrapSchemaProvider(HoodieWriteConfig writeConfig) {
        super(writeConfig);
    }

    @Override
    protected Schema getBootstrapSourceSchema(HoodieEngineContext context, List<Pair<String, List<HoodieFileStatus>>> partitions) {
        MessageType parquetSchema = partitions.stream().flatMap(p -> ((List)p.getValue()).stream()).map(fs -> {
            try {
                Path filePath = FileStatusUtils.toPath(fs.getPath());
                return ParquetUtils.readSchema(context.getHadoopConf().get(), filePath);
            }
            catch (Exception ex) {
                return null;
            }
        }).filter(Objects::nonNull).findAny().orElseThrow(() -> new HoodieException("Could not determine schema from the data files."));
        ParquetToSparkSchemaConverter converter = new ParquetToSparkSchemaConverter(Boolean.parseBoolean(SQLConf.PARQUET_BINARY_AS_STRING().defaultValueString()), Boolean.parseBoolean(SQLConf.PARQUET_INT96_AS_TIMESTAMP().defaultValueString()));
        StructType sparkSchema = converter.convert(parquetSchema);
        String tableName = HoodieAvroUtils.sanitizeName(this.writeConfig.getTableName());
        String structName = tableName + "_record";
        String recordNamespace = "hoodie." + tableName;
        return SchemaConverters.toAvroType((DataType)sparkSchema, false, structName, recordNamespace);
    }
}

