/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.embedded;

import java.io.IOException;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.util.NetworkUtils;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class EmbeddedTimelineService {
    private static final Logger LOG = LogManager.getLogger(EmbeddedTimelineService.class);
    private int serverPort;
    private int preferredPort;
    private String hostAddr;
    private HoodieEngineContext context;
    private final SerializableConfiguration hadoopConf;
    private final FileSystemViewStorageConfig config;
    private final HoodieMetadataConfig metadataConfig;
    private final String basePath;
    private transient FileSystemViewManager viewManager;
    private transient TimelineService server;

    public EmbeddedTimelineService(HoodieEngineContext context, String embeddedTimelineServiceHostAddr, int embeddedTimelineServerPort, HoodieMetadataConfig metadataConfig, FileSystemViewStorageConfig config, String basePath) {
        this.setHostAddr(embeddedTimelineServiceHostAddr);
        this.context = context;
        this.config = config;
        this.basePath = basePath;
        this.metadataConfig = metadataConfig;
        this.hadoopConf = context.getHadoopConf();
        this.viewManager = this.createViewManager();
        this.preferredPort = embeddedTimelineServerPort;
    }

    private FileSystemViewManager createViewManager() {
        FileSystemViewStorageConfig.Builder builder = FileSystemViewStorageConfig.newBuilder().fromProperties(this.config.getProps());
        FileSystemViewStorageType storageType = builder.build().getStorageType();
        if (storageType.equals((Object)FileSystemViewStorageType.REMOTE_ONLY) || storageType.equals((Object)FileSystemViewStorageType.REMOTE_FIRST)) {
            builder.withStorageType(FileSystemViewStorageType.MEMORY);
        }
        return FileSystemViewManager.createViewManager(this.context, this.metadataConfig, builder.build(), this.basePath);
    }

    public void startServer() throws IOException {
        this.server = new TimelineService(this.preferredPort, this.viewManager, this.hadoopConf.newCopy());
        this.serverPort = this.server.startService();
        LOG.info((Object)("Started embedded timeline server at " + this.hostAddr + ":" + this.serverPort));
    }

    private void setHostAddr(String embeddedTimelineServiceHostAddr) {
        if (embeddedTimelineServiceHostAddr != null) {
            LOG.info((Object)("Overriding hostIp to (" + embeddedTimelineServiceHostAddr + ") found in spark-conf. It was " + this.hostAddr));
            this.hostAddr = embeddedTimelineServiceHostAddr;
        } else {
            LOG.warn((Object)"Unable to find driver bind address from spark config");
            this.hostAddr = NetworkUtils.getHostname();
        }
    }

    public FileSystemViewStorageConfig getRemoteFileSystemViewConfig() {
        FileSystemViewStorageType viewStorageType = this.config.shouldEnableBackupForRemoteFileSystemView() ? FileSystemViewStorageType.REMOTE_FIRST : FileSystemViewStorageType.REMOTE_ONLY;
        return FileSystemViewStorageConfig.newBuilder().withStorageType(viewStorageType).withRemoteServerHost(this.hostAddr).withRemoteServerPort(this.serverPort).build();
    }

    public FileSystemViewManager getViewManager() {
        return this.viewManager;
    }

    public void stop() {
        if (null != this.server) {
            LOG.info((Object)"Closing Timeline server");
            this.server.close();
            this.server = null;
            this.viewManager = null;
            LOG.info((Object)"Closed Timeline server");
        }
    }
}

