/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs.inline;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.hudi.common.fs.inline.InLineFSUtils;
import org.apache.hudi.common.fs.inline.InLineFsDataInputStream;

public class InLineFileSystem
extends FileSystem {
    public static final String SCHEME = "inlinefs";
    private Configuration conf = null;

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.conf = conf;
    }

    public URI getUri() {
        return URI.create(this.getScheme());
    }

    public String getScheme() {
        return SCHEME;
    }

    public FSDataInputStream open(Path inlinePath, int bufferSize) throws IOException {
        Path outerPath = InLineFSUtils.getOuterfilePathFromInlinePath(inlinePath);
        FileSystem outerFs = outerPath.getFileSystem(this.conf);
        FSDataInputStream outerStream = outerFs.open(outerPath, bufferSize);
        return new InLineFsDataInputStream(InLineFSUtils.startOffset(inlinePath), outerStream, InLineFSUtils.length(inlinePath));
    }

    public boolean exists(Path f) {
        try {
            return this.getFileStatus(f) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public FileStatus getFileStatus(Path inlinePath) throws IOException {
        Path outerPath = InLineFSUtils.getOuterfilePathFromInlinePath(inlinePath);
        FileSystem outerFs = outerPath.getFileSystem(this.conf);
        FileStatus status = outerFs.getFileStatus(outerPath);
        FileStatus toReturn = new FileStatus((long)InLineFSUtils.length(inlinePath), status.isDirectory(), (int)status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), status.getPermission(), status.getOwner(), status.getGroup(), inlinePath);
        return toReturn;
    }

    public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean b, int i, short i1, long l, Progressable progressable) throws IOException {
        throw new UnsupportedOperationException("Can't rename files");
    }

    public FSDataOutputStream append(Path path, int i, Progressable progressable) throws IOException {
        throw new UnsupportedOperationException("Can't rename files");
    }

    public boolean rename(Path path, Path path1) throws IOException {
        throw new UnsupportedOperationException("Can't rename files");
    }

    public boolean delete(Path path, boolean b) throws IOException {
        throw new UnsupportedOperationException("Can't delete files");
    }

    public FileStatus[] listStatus(Path inlinePath) throws IOException {
        return new FileStatus[]{this.getFileStatus(inlinePath)};
    }

    public void setWorkingDirectory(Path path) {
        throw new UnsupportedOperationException("Can't set working directory");
    }

    public Path getWorkingDirectory() {
        throw new UnsupportedOperationException("Can't get working directory");
    }

    public boolean mkdirs(Path path, FsPermission fsPermission) throws IOException {
        throw new UnsupportedOperationException("Can't set working directory");
    }
}

