/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hudi.common.metrics.Counter;
import org.apache.hudi.common.metrics.Registry;

public class LocalRegistry
implements Registry {
    ConcurrentHashMap<String, Counter> counters = new ConcurrentHashMap();
    private final String name;

    public LocalRegistry(String name) {
        this.name = name;
    }

    @Override
    public void clear() {
        this.counters.clear();
    }

    @Override
    public void increment(String name) {
        this.getCounter(name).increment();
    }

    @Override
    public void add(String name, long value) {
        this.getCounter(name).add(value);
    }

    @Override
    public Map<String, Long> getAllCounts(boolean prefixWithRegistryName) {
        HashMap<String, Long> countersMap = new HashMap<String, Long>();
        this.counters.forEach((k, v) -> {
            String key = prefixWithRegistryName ? this.name + "." + k : k;
            countersMap.put(key, v.getValue());
        });
        return countersMap;
    }

    private synchronized Counter getCounter(String name) {
        if (!this.counters.containsKey(name)) {
            this.counters.put(name, new Counter());
        }
        return this.counters.get(name);
    }
}

