/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.AbstractHoodieLogRecordScanner;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieMergedLogRecordScanner
extends AbstractHoodieLogRecordScanner
implements Iterable<HoodieRecord<? extends HoodieRecordPayload>> {
    private static final Logger LOG = LogManager.getLogger(HoodieMergedLogRecordScanner.class);
    protected final ExternalSpillableMap<String, HoodieRecord<? extends HoodieRecordPayload>> records;
    private long numMergedRecordsInLog;
    private long maxMemorySizeInBytes;
    private long totalTimeTakenToReadAndMergeBlocks;
    public final HoodieTimer timer = new HoodieTimer();

    public HoodieMergedLogRecordScanner(FileSystem fs, String basePath, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, Long maxMemorySizeInBytes, boolean readBlocksLazily, boolean reverseReader, int bufferSize, String spillableMapBasePath) {
        this(fs, basePath, logFilePaths, readerSchema, latestInstantTime, maxMemorySizeInBytes, readBlocksLazily, reverseReader, bufferSize, spillableMapBasePath, true);
    }

    public HoodieMergedLogRecordScanner(FileSystem fs, String basePath, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, Long maxMemorySizeInBytes, boolean readBlocksLazily, boolean reverseReader, int bufferSize, String spillableMapBasePath, boolean autoScan) {
        super(fs, basePath, logFilePaths, readerSchema, latestInstantTime, readBlocksLazily, reverseReader, bufferSize);
        try {
            this.records = new ExternalSpillableMap(maxMemorySizeInBytes, spillableMapBasePath, new DefaultSizeEstimator(), new HoodieRecordSizeEstimator(readerSchema));
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException when creating ExternalSpillableMap at " + spillableMapBasePath, e);
        }
        if (autoScan) {
            this.performScan();
        }
    }

    protected void performScan() {
        this.timer.startTimer();
        this.scan();
        this.totalTimeTakenToReadAndMergeBlocks = this.timer.endTimer();
        this.numMergedRecordsInLog = this.records.size();
        LOG.info((Object)("Number of log files scanned => " + this.logFilePaths.size()));
        LOG.info((Object)("MaxMemoryInBytes allowed for compaction => " + this.maxMemorySizeInBytes));
        LOG.info((Object)("Number of entries in MemoryBasedMap in ExternalSpillableMap => " + this.records.getInMemoryMapNumEntries()));
        LOG.info((Object)("Total size in bytes of MemoryBasedMap in ExternalSpillableMap => " + this.records.getCurrentInMemoryMapSize()));
        LOG.info((Object)("Number of entries in DiskBasedMap in ExternalSpillableMap => " + this.records.getDiskBasedMapNumEntries()));
        LOG.info((Object)("Size of file spilled to disk => " + this.records.getSizeOfFileOnDiskInBytes()));
    }

    @Override
    public Iterator<HoodieRecord<? extends HoodieRecordPayload>> iterator() {
        return this.records.iterator();
    }

    public Map<String, HoodieRecord<? extends HoodieRecordPayload>> getRecords() {
        return this.records;
    }

    public long getNumMergedRecordsInLog() {
        return this.numMergedRecordsInLog;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    protected void processNextRecord(HoodieRecord<? extends HoodieRecordPayload> hoodieRecord) throws IOException {
        String key = hoodieRecord.getRecordKey();
        if (this.records.containsKey(key)) {
            Object combinedValue = hoodieRecord.getData().preCombine(((HoodieRecord)this.records.get(key)).getData());
            this.records.put(key, new HoodieRecord(new HoodieKey(key, hoodieRecord.getPartitionPath()), combinedValue));
        } else {
            this.records.put(key, hoodieRecord);
        }
    }

    @Override
    protected void processNextDeletedKey(HoodieKey hoodieKey) {
        this.records.put(hoodieKey.getRecordKey(), (HoodieRecord<? extends HoodieRecordPayload>)((Serializable)SpillableMapUtils.generateEmptyPayload(hoodieKey.getRecordKey(), hoodieKey.getPartitionPath(), this.getPayloadClassFQN())));
    }

    public long getTotalTimeTakenToReadAndMergeBlocks() {
        return this.totalTimeTakenToReadAndMergeBlocks;
    }

    public void close() {
        if (this.records != null) {
            this.records.close();
        }
    }

    public static class Builder
    extends AbstractHoodieLogRecordScanner.Builder {
        private FileSystem fs;
        private String basePath;
        private List<String> logFilePaths;
        private Schema readerSchema;
        private String latestInstantTime;
        private boolean readBlocksLazily;
        private boolean reverseReader;
        private int bufferSize;
        private Long maxMemorySizeInBytes;
        private String spillableMapBasePath;

        @Override
        public Builder withFileSystem(FileSystem fs) {
            this.fs = fs;
            return this;
        }

        @Override
        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Override
        public Builder withLogFilePaths(List<String> logFilePaths) {
            this.logFilePaths = logFilePaths;
            return this;
        }

        @Override
        public Builder withReaderSchema(Schema schema) {
            this.readerSchema = schema;
            return this;
        }

        @Override
        public Builder withLatestInstantTime(String latestInstantTime) {
            this.latestInstantTime = latestInstantTime;
            return this;
        }

        @Override
        public Builder withReadBlocksLazily(boolean readBlocksLazily) {
            this.readBlocksLazily = readBlocksLazily;
            return this;
        }

        @Override
        public Builder withReverseReader(boolean reverseReader) {
            this.reverseReader = reverseReader;
            return this;
        }

        @Override
        public Builder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder withMaxMemorySizeInBytes(Long maxMemorySizeInBytes) {
            this.maxMemorySizeInBytes = maxMemorySizeInBytes;
            return this;
        }

        public Builder withSpillableMapBasePath(String spillableMapBasePath) {
            this.spillableMapBasePath = spillableMapBasePath;
            return this;
        }

        @Override
        public HoodieMergedLogRecordScanner build() {
            return new HoodieMergedLogRecordScanner(this.fs, this.basePath, this.logFilePaths, this.readerSchema, this.latestInstantTime, this.maxMemorySizeInBytes, this.readBlocksLazily, this.reverseReader, this.bufferSize, this.spillableMapBasePath);
        }
    }
}

