/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.queue.BoundedInMemoryQueueConsumer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.execution.HoodieLazyInsertIterable;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;

public class CopyOnWriteInsertHandler<T extends HoodieRecordPayload>
extends BoundedInMemoryQueueConsumer<HoodieLazyInsertIterable.HoodieInsertValueGenResult<HoodieRecord>, List<WriteStatus>> {
    private HoodieWriteConfig config;
    private String instantTime;
    private boolean areRecordsSorted;
    private HoodieTable hoodieTable;
    private String idPrefix;
    private TaskContextSupplier taskContextSupplier;
    private WriteHandleFactory writeHandleFactory;
    private final List<WriteStatus> statuses = new ArrayList<WriteStatus>();
    private Map<String, HoodieWriteHandle> handles = new HashMap<String, HoodieWriteHandle>();

    public CopyOnWriteInsertHandler(HoodieWriteConfig config, String instantTime, boolean areRecordsSorted, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, WriteHandleFactory writeHandleFactory) {
        this.config = config;
        this.instantTime = instantTime;
        this.areRecordsSorted = areRecordsSorted;
        this.hoodieTable = hoodieTable;
        this.idPrefix = idPrefix;
        this.taskContextSupplier = taskContextSupplier;
        this.writeHandleFactory = writeHandleFactory;
    }

    @Override
    public void consumeOneRecord(HoodieLazyInsertIterable.HoodieInsertValueGenResult<HoodieRecord> payload) {
        Object insertPayload = payload.record;
        String partitionPath = ((HoodieRecord)insertPayload).getPartitionPath();
        HoodieWriteHandle handle = this.handles.get(partitionPath);
        if (handle == null) {
            if (this.areRecordsSorted) {
                this.closeOpenHandles();
            }
            handle = this.writeHandleFactory.create(this.config, this.instantTime, this.hoodieTable, ((HoodieRecord)insertPayload).getPartitionPath(), this.idPrefix, this.taskContextSupplier);
            this.handles.put(partitionPath, handle);
        }
        if (!handle.canWrite((HoodieRecord)payload.record)) {
            this.statuses.addAll(handle.close());
            handle = this.writeHandleFactory.create(this.config, this.instantTime, this.hoodieTable, ((HoodieRecord)insertPayload).getPartitionPath(), this.idPrefix, this.taskContextSupplier);
            this.handles.put(partitionPath, handle);
        }
        handle.write((HoodieRecord)insertPayload, payload.insertValue, payload.exception);
    }

    @Override
    public void finish() {
        this.closeOpenHandles();
        assert (this.statuses.size() > 0);
    }

    @Override
    public List<WriteStatus> getResult() {
        return this.statuses;
    }

    private void closeOpenHandles() {
        for (HoodieWriteHandle handle : this.handles.values()) {
            this.statuses.addAll(handle.close());
        }
        this.handles.clear();
    }
}

