/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputSplitWithLocationInfo;
import org.apache.hudi.hadoop.InputSplitUtils;

public interface RealtimeSplit
extends InputSplitWithLocationInfo {
    public List<String> getDeltaLogPaths();

    public String getMaxCommitTime();

    public String getBasePath();

    public void setDeltaLogPaths(List<String> var1);

    public void setMaxCommitTime(String var1);

    public void setBasePath(String var1);

    default public void writeToOutput(DataOutput out) throws IOException {
        InputSplitUtils.writeString(this.getBasePath(), out);
        InputSplitUtils.writeString(this.getMaxCommitTime(), out);
        out.writeInt(this.getDeltaLogPaths().size());
        for (String logFilePath : this.getDeltaLogPaths()) {
            InputSplitUtils.writeString(logFilePath, out);
        }
    }

    default public void readFromInput(DataInput in) throws IOException {
        this.setBasePath(InputSplitUtils.readString(in));
        this.setMaxCommitTime(InputSplitUtils.readString(in));
        int totalLogFiles = in.readInt();
        ArrayList<String> deltaLogPaths = new ArrayList<String>(totalLogFiles);
        for (int i = 0; i < totalLogFiles; ++i) {
            deltaLogPaths.add(InputSplitUtils.readString(in));
        }
        this.setDeltaLogPaths(deltaLogPaths);
    }

    public Path getPath();

    public long getStart();

    public long getLength();
}

