/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.util.Properties;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieMemoryConfig;

public class IOUtils {
    public static long getMaxMemoryAllowedForMerge(TaskContextSupplier context, String maxMemoryFraction) {
        Option<String> totalMemoryOpt = context.getProperty(EngineProperty.TOTAL_MEMORY_AVAILABLE);
        Option<String> memoryFractionOpt = context.getProperty(EngineProperty.MEMORY_FRACTION_IN_USE);
        if (totalMemoryOpt.isPresent() && memoryFractionOpt.isPresent()) {
            long executorMemoryInBytes = Long.parseLong(totalMemoryOpt.get());
            double memoryFraction = Double.parseDouble(memoryFractionOpt.get());
            double maxMemoryFractionForMerge = Double.parseDouble(maxMemoryFraction);
            double userAvailableMemory = (double)executorMemoryInBytes * (1.0 - memoryFraction);
            long maxMemoryForMerge = (long)Math.floor(userAvailableMemory * maxMemoryFractionForMerge);
            return Math.max(0x6400000L, maxMemoryForMerge);
        }
        return 0x40000000L;
    }

    public static long getMaxMemoryPerPartitionMerge(TaskContextSupplier context, Properties properties) {
        if (properties.containsKey("hoodie.memory.merge.max.size")) {
            return Long.parseLong(properties.getProperty("hoodie.memory.merge.max.size"));
        }
        String fraction = properties.getProperty("hoodie.memory.merge.fraction", HoodieMemoryConfig.DEFAULT_MAX_MEMORY_FRACTION_FOR_MERGE);
        return IOUtils.getMaxMemoryAllowedForMerge(context, fraction);
    }

    public static long getMaxMemoryPerCompaction(TaskContextSupplier context, Properties properties) {
        if (properties.containsKey("hoodie.memory.compaction.max.size")) {
            return Long.parseLong(properties.getProperty("hoodie.memory.compaction.max.size"));
        }
        String fraction = properties.getProperty("hoodie.memory.compaction.fraction", HoodieMemoryConfig.DEFAULT_MAX_MEMORY_FRACTION_FOR_COMPACTION);
        return IOUtils.getMaxMemoryAllowedForMerge(context, fraction);
    }
}

