/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.storage.HoodieAvroParquetConfig;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieHFileConfig;
import org.apache.hudi.io.storage.HoodieHFileWriter;
import org.apache.hudi.io.storage.HoodieParquetWriter;
import org.apache.hudi.table.HoodieTable;
import org.apache.parquet.avro.AvroSchemaConverter;

public class HoodieFileWriterFactory {
    public static <T extends HoodieRecordPayload, R extends IndexedRecord, I, K, O> HoodieFileWriter<R> getFileWriter(String instantTime, Path path, HoodieTable<T, I, K, O> hoodieTable, HoodieWriteConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        String extension = FSUtils.getFileExtension(path.getName());
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return HoodieFileWriterFactory.newParquetFileWriter(instantTime, path, config, schema, hoodieTable, taskContextSupplier);
        }
        if (HoodieFileFormat.HFILE.getFileExtension().equals(extension)) {
            return HoodieFileWriterFactory.newHFileFileWriter(instantTime, path, config, schema, hoodieTable, taskContextSupplier);
        }
        throw new UnsupportedOperationException(extension + " format not supported yet.");
    }

    private static <T extends HoodieRecordPayload, R extends IndexedRecord> HoodieFileWriter<R> newParquetFileWriter(String instantTime, Path path, HoodieWriteConfig config, Schema schema, HoodieTable hoodieTable, TaskContextSupplier taskContextSupplier) throws IOException {
        BloomFilter filter = HoodieFileWriterFactory.createBloomFilter(config);
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter().convert(schema), schema, filter);
        HoodieAvroParquetConfig parquetConfig = new HoodieAvroParquetConfig(writeSupport, config.getParquetCompressionCodec(), config.getParquetBlockSize(), config.getParquetPageSize(), config.getParquetMaxFileSize(), hoodieTable.getHadoopConf(), config.getParquetCompressionRatio());
        return new HoodieParquetWriter(instantTime, path, parquetConfig, schema, taskContextSupplier);
    }

    private static <T extends HoodieRecordPayload, R extends IndexedRecord> HoodieFileWriter<R> newHFileFileWriter(String instantTime, Path path, HoodieWriteConfig config, Schema schema, HoodieTable hoodieTable, TaskContextSupplier taskContextSupplier) throws IOException {
        BloomFilter filter = HoodieFileWriterFactory.createBloomFilter(config);
        HoodieHFileConfig hfileConfig = new HoodieHFileConfig(hoodieTable.getHadoopConf(), config.getHFileCompressionAlgorithm(), config.getHFileBlockSize(), config.getHFileMaxFileSize(), filter);
        return new HoodieHFileWriter(instantTime, path, hfileConfig, schema, taskContextSupplier);
    }

    private static BloomFilter createBloomFilter(HoodieWriteConfig config) {
        return BloomFilterFactory.createBloomFilter(config.getBloomFilterNumEntries(), config.getBloomFilterFPP(), config.getDynamicBloomFilterMaxNumEntries(), config.getBloomFilterType());
    }
}

