/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hudi.common.bloom.BloomFilter;

public class HoodieHFileConfig {
    private Compression.Algorithm compressionAlgorithm;
    private int blockSize;
    private long maxFileSize;
    private boolean prefetchBlocksOnOpen;
    private boolean cacheDataInL1;
    private boolean dropBehindCacheCompaction;
    private Configuration hadoopConf;
    private BloomFilter bloomFilter;
    private static boolean DROP_BEHIND_CACHE_COMPACTION_DEFAULT = true;

    public HoodieHFileConfig(Configuration hadoopConf, Compression.Algorithm compressionAlgorithm, int blockSize, long maxFileSize, BloomFilter bloomFilter) {
        this(hadoopConf, compressionAlgorithm, blockSize, maxFileSize, false, false, DROP_BEHIND_CACHE_COMPACTION_DEFAULT, bloomFilter);
    }

    public HoodieHFileConfig(Configuration hadoopConf, Compression.Algorithm compressionAlgorithm, int blockSize, long maxFileSize, boolean prefetchBlocksOnOpen, boolean cacheDataInL1, boolean dropBehindCacheCompaction, BloomFilter bloomFilter) {
        this.hadoopConf = hadoopConf;
        this.compressionAlgorithm = compressionAlgorithm;
        this.blockSize = blockSize;
        this.maxFileSize = maxFileSize;
        this.prefetchBlocksOnOpen = prefetchBlocksOnOpen;
        this.cacheDataInL1 = cacheDataInL1;
        this.dropBehindCacheCompaction = dropBehindCacheCompaction;
        this.bloomFilter = bloomFilter;
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public Compression.Algorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public boolean shouldPrefetchBlocksOnOpen() {
        return this.prefetchBlocksOnOpen;
    }

    public boolean shouldCacheDataInL1() {
        return this.cacheDataInL1;
    }

    public boolean shouldDropBehindCacheCompaction() {
        return this.dropBehindCacheCompaction;
    }

    public boolean useBloomFilter() {
        return this.bloomFilter != null;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }
}

