/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.keygen.parser.AbstractHoodieDateTimeParser;
import org.apache.hudi.keygen.parser.HoodieDateTimeParserImpl;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimestampBasedAvroKeyGenerator
extends SimpleAvroKeyGenerator {
    private final TimeUnit timeUnit;
    private final TimestampType timestampType;
    private final String outputDateFormat;
    private transient Option<DateTimeFormatter> inputFormatter;
    private transient DateTimeFormatter partitionFormatter;
    private final AbstractHoodieDateTimeParser parser;
    private final DateTimeZone inputDateTimeZone;
    private final DateTimeZone outputDateTimeZone;
    protected final boolean encodePartitionPath;

    public TimestampBasedAvroKeyGenerator(TypedProperties config) throws IOException {
        this(config, config.getString("hoodie.datasource.write.recordkey.field"), config.getString("hoodie.datasource.write.partitionpath.field"));
    }

    TimestampBasedAvroKeyGenerator(TypedProperties config, String partitionPathField) throws IOException {
        this(config, null, partitionPathField);
    }

    TimestampBasedAvroKeyGenerator(TypedProperties config, String recordKeyField, String partitionPathField) throws IOException {
        super(config, recordKeyField, partitionPathField);
        String dateTimeParserClass = config.getString("hoodie.deltastreamer.keygen.datetime.parser.class", HoodieDateTimeParserImpl.class.getName());
        this.parser = KeyGenUtils.createDateTimeParser(config, dateTimeParserClass);
        this.inputDateTimeZone = this.parser.getInputDateTimeZone();
        this.outputDateTimeZone = this.parser.getOutputDateTimeZone();
        this.outputDateFormat = this.parser.getOutputDateFormat();
        this.timestampType = TimestampType.valueOf(config.getString("hoodie.deltastreamer.keygen.timebased.timestamp.type"));
        switch (this.timestampType) {
            case EPOCHMILLISECONDS: {
                this.timeUnit = TimeUnit.MILLISECONDS;
                break;
            }
            case UNIX_TIMESTAMP: {
                this.timeUnit = TimeUnit.SECONDS;
                break;
            }
            case SCALAR: {
                String timeUnitStr = config.getString("hoodie.deltastreamer.keygen.timebased.timestamp.scalar.time.unit", TimeUnit.SECONDS.toString());
                this.timeUnit = TimeUnit.valueOf(timeUnitStr.toUpperCase());
                break;
            }
            default: {
                this.timeUnit = null;
            }
        }
        this.encodePartitionPath = config.getBoolean("hoodie.datasource.write.partitionpath.urlencode", Boolean.parseBoolean("false"));
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        Object partitionVal = HoodieAvroUtils.getNestedFieldVal(record, this.getPartitionPathFields().get(0), true);
        if (partitionVal == null) {
            partitionVal = this.getDefaultPartitionVal();
        }
        try {
            return this.getPartitionPath(partitionVal);
        }
        catch (Exception e) {
            throw new HoodieKeyGeneratorException("Unable to parse input partition field :" + partitionVal, e);
        }
    }

    public Object getDefaultPartitionVal() {
        Long result = 1L;
        if (this.timestampType == TimestampType.DATE_STRING || this.timestampType == TimestampType.MIXED) {
            String delimiter = this.parser.getConfigInputDateFormatDelimiter();
            String format = this.config.getString("hoodie.deltastreamer.keygen.timebased.input.dateformat", "").split(delimiter)[0];
            if (null != this.inputDateTimeZone) {
                return new DateTime((Object)result, this.inputDateTimeZone).toString(format);
            }
            if (null != this.outputDateTimeZone) {
                return new DateTime((Object)result, this.outputDateTimeZone).toString(format);
            }
            return new DateTime((Object)result, DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("GMT"))).toString(format);
        }
        return result;
    }

    private void initIfNeeded() {
        if (this.inputFormatter == null) {
            this.inputFormatter = this.parser.getInputFormatter();
        }
        if (this.partitionFormatter == null) {
            this.partitionFormatter = DateTimeFormat.forPattern((String)this.outputDateFormat);
            if (this.outputDateTimeZone != null) {
                this.partitionFormatter = this.partitionFormatter.withZone(this.outputDateTimeZone);
            }
        }
    }

    public String getPartitionPath(Object partitionVal) {
        long timeMs;
        this.initIfNeeded();
        if (partitionVal instanceof Double) {
            timeMs = this.convertLongTimeToMillis(((Double)partitionVal).longValue());
        } else if (partitionVal instanceof Float) {
            timeMs = this.convertLongTimeToMillis(((Float)partitionVal).longValue());
        } else if (partitionVal instanceof Long) {
            timeMs = this.convertLongTimeToMillis((Long)partitionVal);
        } else if (partitionVal instanceof CharSequence) {
            if (!this.inputFormatter.isPresent()) {
                throw new HoodieException("Missing inputformatter. Ensure hoodie.deltastreamer.keygen.timebased.input.dateformat config is set when timestampType is DATE_STRING or MIXED!");
            }
            DateTime parsedDateTime = this.inputFormatter.get().parseDateTime(partitionVal.toString());
            if (this.outputDateTimeZone == null) {
                this.partitionFormatter = this.partitionFormatter.withZone(parsedDateTime.getZone());
            }
            timeMs = this.inputFormatter.get().parseDateTime(partitionVal.toString()).getMillis();
        } else {
            throw new HoodieNotSupportedException("Unexpected type for partition field: " + partitionVal.getClass().getName());
        }
        DateTime timestamp = new DateTime(timeMs, this.outputDateTimeZone);
        String partitionPath = timestamp.toString(this.partitionFormatter);
        if (this.encodePartitionPath) {
            try {
                partitionPath = URLEncoder.encode(partitionPath, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException uoe) {
                throw new HoodieException(uoe.getMessage(), uoe);
            }
        }
        return this.hiveStylePartitioning ? this.getPartitionPathFields().get(0) + "=" + partitionPath : partitionPath;
    }

    private long convertLongTimeToMillis(Long partitionVal) {
        if (this.timeUnit == null) {
            throw new RuntimeException("hoodie.deltastreamer.keygen.timebased.timestamp.scalar.time.unit is not specified but scalar it supplied as time value");
        }
        return TimeUnit.MILLISECONDS.convert(partitionVal, this.timeUnit);
    }

    public static class Config {
        public static final String TIMESTAMP_TYPE_FIELD_PROP = "hoodie.deltastreamer.keygen.timebased.timestamp.type";
        public static final String INPUT_TIME_UNIT = "hoodie.deltastreamer.keygen.timebased.timestamp.scalar.time.unit";
        public static final String TIMESTAMP_INPUT_DATE_FORMAT_PROP = "hoodie.deltastreamer.keygen.timebased.input.dateformat";
        public static final String TIMESTAMP_INPUT_DATE_FORMAT_LIST_DELIMITER_REGEX_PROP = "hoodie.deltastreamer.keygen.timebased.input.dateformat.list.delimiter.regex";
        public static final String TIMESTAMP_INPUT_TIMEZONE_FORMAT_PROP = "hoodie.deltastreamer.keygen.timebased.input.timezone";
        public static final String TIMESTAMP_OUTPUT_DATE_FORMAT_PROP = "hoodie.deltastreamer.keygen.timebased.output.dateformat";
        public static final String TIMESTAMP_TIMEZONE_FORMAT_PROP = "hoodie.deltastreamer.keygen.timebased.timezone";
        public static final String TIMESTAMP_OUTPUT_TIMEZONE_FORMAT_PROP = "hoodie.deltastreamer.keygen.timebased.output.timezone";
        static final String DATE_TIME_PARSER_PROP = "hoodie.deltastreamer.keygen.datetime.parser.class";
    }

    public static enum TimestampType implements Serializable
    {
        UNIX_TIMESTAMP,
        DATE_STRING,
        MIXED,
        EPOCHMILLISECONDS,
        SCALAR;

    }
}

