/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TimelineMergedTableMetadata
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(TimelineMergedTableMetadata.class);
    HoodieTableMetaClient metaClient;
    private List<HoodieInstant> instants;
    private Option<String> lastSyncTs;
    private Set<String> mergeKeyFilter;
    protected final Map<String, HoodieRecord<? extends HoodieRecordPayload>> timelineMergedRecords;

    public TimelineMergedTableMetadata(HoodieTableMetaClient metaClient, List<HoodieInstant> instants, Option<String> lastSyncTs, Set<String> mergeKeyFilter) {
        this.metaClient = metaClient;
        this.instants = instants;
        this.lastSyncTs = lastSyncTs;
        this.mergeKeyFilter = mergeKeyFilter != null ? mergeKeyFilter : Collections.emptySet();
        this.timelineMergedRecords = new HashMap<String, HoodieRecord<? extends HoodieRecordPayload>>();
        this.scan();
    }

    private void scan() {
        for (HoodieInstant instant : this.instants) {
            try {
                Option<List<HoodieRecord>> records = HoodieTableMetadataUtil.convertInstantToMetaRecords(this.metaClient, instant, this.lastSyncTs);
                if (!records.isPresent()) continue;
                records.get().forEach(record -> this.processNextRecord((HoodieRecord<? extends HoodieRecordPayload>)record));
            }
            catch (Exception e) {
                LOG.error((Object)String.format("Got exception when processing timeline instant %s", instant.getTimestamp()), (Throwable)e);
                throw new HoodieException(String.format("Got exception when processing timeline instant %s", instant.getTimestamp()), e);
            }
        }
    }

    private void processNextRecord(HoodieRecord<? extends HoodieRecordPayload> hoodieRecord) {
        String key = hoodieRecord.getRecordKey();
        if (this.mergeKeyFilter.isEmpty() || this.mergeKeyFilter.contains(key)) {
            if (this.timelineMergedRecords.containsKey(key)) {
                HoodieRecordPayload combinedValue = hoodieRecord.getData().preCombine(this.timelineMergedRecords.get(key).getData(), new Properties());
                this.timelineMergedRecords.put(key, new HoodieRecord<HoodieRecordPayload>(new HoodieKey(key, hoodieRecord.getPartitionPath()), combinedValue));
            } else {
                this.timelineMergedRecords.put(key, hoodieRecord);
            }
        }
    }

    public Option<HoodieRecord<HoodieMetadataPayload>> getRecordByKey(String key) {
        return Option.ofNullable(this.timelineMergedRecords.get(key));
    }
}

