/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseSparkCommitActionExecutor;
import org.apache.hudi.table.action.commit.SparkWriteHelper;
import org.apache.spark.api.java.JavaRDD;

public class SparkInsertCommitActionExecutor<T extends HoodieRecordPayload<T>>
extends BaseSparkCommitActionExecutor<T> {
    private final JavaRDD<HoodieRecord<T>> inputRecordsRDD;

    public SparkInsertCommitActionExecutor(HoodieSparkEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, JavaRDD<HoodieRecord<T>> inputRecordsRDD) {
        super(context, config, table, instantTime, WriteOperationType.INSERT);
        this.inputRecordsRDD = inputRecordsRDD;
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> execute() {
        return SparkWriteHelper.newInstance().write(this.instantTime, this.inputRecordsRDD, this.context, this.table, this.config.shouldCombineBeforeInsert(), this.config.getInsertShuffleParallelism(), this, false);
    }
}

