/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.util;

import io.javalin.Context;
import io.javalin.core.util.ContextUtil;
import io.javalin.core.util.SinglePageHandler$WhenMappings;
import io.javalin.core.util.Util;
import io.javalin.staticfiles.Location;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/javalin/core/util/SinglePageHandler;", "", "()V", "pathPageMap", "", "", "pathUrlMap", "Ljava/net/URL;", "add", "", "path", "filePath", "location", "Lio/javalin/staticfiles/Location;", "handle", "", "ctx", "Lio/javalin/Context;", "javalin"})
public final class SinglePageHandler {
    private final Map<String, URL> pathUrlMap;
    private final Map<String, String> pathPageMap;

    public final void add(@NotNull String path, @NotNull String filePath, @NotNull Location location) {
        URL uRL;
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(filePath, "filePath");
        Intrinsics.checkParameterIsNotNull((Object)location, "location");
        Map<String, Object> map = this.pathUrlMap;
        switch (SinglePageHandler$WhenMappings.$EnumSwitchMapping$0[location.ordinal()]) {
            case 1: {
                uRL = Util.INSTANCE.getResourceUrl(StringsKt.removePrefix(filePath, (CharSequence)"/"));
                if (uRL != null) break;
                throw (Throwable)new IllegalArgumentException("File at '" + filePath + "' not found. Path should be relative to resource folder.");
            }
            case 2: {
                uRL = Util.INSTANCE.getFileUrl(filePath);
                if (uRL != null) break;
                throw (Throwable)new IllegalArgumentException("External file at '" + filePath + "' not found.");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object object = uRL;
        map.put(path, (URL)object);
        map = this.pathPageMap;
        URL uRL2 = this.pathUrlMap.get(path);
        if (uRL2 == null) {
            Intrinsics.throwNpe();
        }
        object = uRL2;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)object);
        object = new String(byArray, charset);
        map.put(path, (URL)object);
    }

    public final boolean handle(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        if (!ContextUtil.INSTANCE.acceptsHtml(ctx)) {
            return false;
        }
        for (String path : this.pathPageMap.keySet()) {
            String string;
            if (!StringsKt.startsWith$default(ctx.path(), path, false, 2, null)) continue;
            Context context = ctx;
            boolean bl = ContextUtil.INSTANCE.isLocalhost(ctx);
            if (bl) {
                URL uRL = this.pathUrlMap.get(path);
                if (uRL == null) {
                    Intrinsics.throwNpe();
                }
                URL uRL2 = uRL;
                Context context2 = context;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes(uRL2);
                String string2 = new String(byArray, charset);
                context = context2;
                string = string2;
            } else if (!bl) {
                String string3 = this.pathPageMap.get(path);
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                string = string3;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            context.html(string);
            return true;
        }
        return false;
    }

    public SinglePageHandler() {
        Map map;
        SinglePageHandler singlePageHandler = this;
        singlePageHandler.pathUrlMap = map = (Map)new LinkedHashMap();
        singlePageHandler = this;
        singlePageHandler.pathPageMap = map = (Map)new LinkedHashMap();
    }
}

