/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;

public class TestKeyValue
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestKeyValue.class);
    private final byte[] rowA = Bytes.toBytes("rowA");
    private final byte[] rowB = Bytes.toBytes("rowB");
    private final byte[] family = Bytes.toBytes("family");
    private final byte[] qualA = Bytes.toBytes("qfA");
    private final byte[] qualB = Bytes.toBytes("qfB");

    public void testColumnCompare() throws Exception {
        byte[] a = Bytes.toBytes("aaa");
        byte[] family1 = Bytes.toBytes("abc");
        byte[] qualifier1 = Bytes.toBytes("def");
        byte[] family2 = Bytes.toBytes("abcd");
        byte[] qualifier2 = Bytes.toBytes("ef");
        KeyValue aaa = new KeyValue(a, family1, qualifier1, 0L, KeyValue.Type.Put, a);
        TestKeyValue.assertFalse((boolean)CellUtil.matchingColumn(aaa, family2, qualifier2));
        TestKeyValue.assertTrue((boolean)CellUtil.matchingColumn(aaa, family1, qualifier1));
        aaa = new KeyValue(a, family2, qualifier2, 0L, KeyValue.Type.Put, a);
        TestKeyValue.assertFalse((boolean)CellUtil.matchingColumn(aaa, family1, qualifier1));
        TestKeyValue.assertTrue((boolean)CellUtil.matchingColumn(aaa, family2, qualifier2));
        byte[] nullQualifier = new byte[]{};
        aaa = new KeyValue(a, family1, nullQualifier, 0L, KeyValue.Type.Put, a);
        TestKeyValue.assertTrue((boolean)CellUtil.matchingColumn(aaa, family1, null));
        TestKeyValue.assertFalse((boolean)CellUtil.matchingColumn(aaa, family2, qualifier2));
    }

    public void testColumnCompare_prefix() throws Exception {
        byte[] a = Bytes.toBytes("aaa");
        byte[] family1 = Bytes.toBytes("abc");
        byte[] qualifier1 = Bytes.toBytes("def");
        byte[] family2 = Bytes.toBytes("ab");
        byte[] qualifier2 = Bytes.toBytes("def");
        KeyValue aaa = new KeyValue(a, family1, qualifier1, 0L, KeyValue.Type.Put, a);
        TestKeyValue.assertFalse((boolean)CellUtil.matchingColumn(aaa, family2, qualifier2));
    }

    public void testBasics() throws Exception {
        LOG.info((Object)("LOWKEY: " + KeyValue.LOWESTKEY.toString()));
        this.check(Bytes.toBytes(this.getName()), Bytes.toBytes(this.getName()), Bytes.toBytes(this.getName()), 1L, Bytes.toBytes(this.getName()));
        this.check(Bytes.toBytes(this.getName()), Bytes.toBytes(this.getName()), null, 1L, null);
        this.check(HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes(this.getName()), null, 1L, null);
        TestKeyValue.assertEquals((Object)new KeyValue(Bytes.toBytes("rk"), Bytes.toBytes("fam"), null, 1L, (byte[])null), (Object)new KeyValue(Bytes.toBytes("rk"), Bytes.toBytes("fam"), HConstants.EMPTY_BYTE_ARRAY, 1L, (byte[])null));
    }

    private void check(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte[] value) {
        KeyValue kv = new KeyValue(row, family, qualifier, timestamp, value);
        TestKeyValue.assertTrue((Bytes.compareTo(kv.getRow(), row) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((boolean)CellUtil.matchingColumn(kv, family, qualifier));
        LOG.info((Object)kv.toString());
    }

    public void testPlainCompare() throws Exception {
        KeyValue bbb;
        byte[] qf;
        byte[] a = Bytes.toBytes("aaa");
        byte[] b = Bytes.toBytes("bbb");
        byte[] fam = Bytes.toBytes("col");
        KeyValue aaa = new KeyValue(a, fam, qf = Bytes.toBytes("umn"), a);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, bbb = new KeyValue(b, fam, qf, b)) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(bbb, aaa) > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(bbb, bbb) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, aaa) == 0 ? 1 : 0) != 0);
        aaa = new KeyValue(a, fam, qf, 1L, a);
        bbb = new KeyValue(a, fam, qf, 2L, a);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, bbb) > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(bbb, aaa) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, aaa) == 0 ? 1 : 0) != 0);
        aaa = new KeyValue(a, fam, qf, 1L, KeyValue.Type.Delete, a);
        bbb = new KeyValue(a, fam, qf, 1L, a);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, bbb) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(bbb, aaa) > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, aaa) == 0 ? 1 : 0) != 0);
    }

    public void testMoreComparisons() throws Exception {
        long now = System.currentTimeMillis();
        KeyValue aaa = new KeyValue(Bytes.toBytes("TestScanMultipleVersions,row_0500,1236020145502"), now);
        KeyValue.MetaComparator c = new KeyValue.MetaComparator();
        KeyValue bbb = new KeyValue(Bytes.toBytes("TestScanMultipleVersions,,99999999999999"), now);
        TestKeyValue.assertTrue((((KeyValue.KVComparator)c).compare(bbb, aaa) < 0 ? 1 : 0) != 0);
        KeyValue aaaa = new KeyValue(Bytes.toBytes("TestScanMultipleVersions,,1236023996656"), Bytes.toBytes("info"), Bytes.toBytes("regioninfo"), 1236024396271L, (byte[])null);
        TestKeyValue.assertTrue((((KeyValue.KVComparator)c).compare(aaaa, bbb) < 0 ? 1 : 0) != 0);
        KeyValue x = new KeyValue(Bytes.toBytes("TestScanMultipleVersions,row_0500,1236034574162"), Bytes.toBytes("info"), Bytes.toBytes(""), Long.MAX_VALUE, (byte[])null);
        KeyValue y = new KeyValue(Bytes.toBytes("TestScanMultipleVersions,row_0500,1236034574162"), Bytes.toBytes("info"), Bytes.toBytes("regioninfo"), 1236034574912L, (byte[])null);
        TestKeyValue.assertTrue((((KeyValue.KVComparator)c).compare(x, y) < 0 ? 1 : 0) != 0);
        this.comparisons(new KeyValue.MetaComparator());
        this.comparisons(new KeyValue.KVComparator());
        this.metacomparisons(new KeyValue.MetaComparator());
    }

    public void testMetaComparatorTableKeysWithCommaOk() {
        KeyValue b;
        KeyValue.MetaComparator c = new KeyValue.MetaComparator();
        long now = System.currentTimeMillis();
        KeyValue a = new KeyValue(Bytes.toBytes("table,key,with,commas1,1234"), now);
        TestKeyValue.assertTrue((c.compare(a, b = new KeyValue(Bytes.toBytes("table,key,with,commas2,0123"), now)) < 0 ? 1 : 0) != 0);
    }

    public void testKeyValueBorderCases() throws IOException {
        KeyValue rowB;
        KeyValue rowA = new KeyValue(Bytes.toBytes("testtable,www.hbase.org/,1234"), Bytes.toBytes("fam"), Bytes.toBytes(""), Long.MAX_VALUE, (byte[])null);
        TestKeyValue.assertTrue((KeyValue.META_COMPARATOR.compare(rowA, rowB = new KeyValue(Bytes.toBytes("testtable,www.hbase.org/%20,99999"), Bytes.toBytes("fam"), Bytes.toBytes(""), Long.MAX_VALUE, (byte[])null)) < 0 ? 1 : 0) != 0);
        rowA = new KeyValue(Bytes.toBytes("testtable,,1234"), Bytes.toBytes("fam"), Bytes.toBytes(""), Long.MAX_VALUE, (byte[])null);
        rowB = new KeyValue(Bytes.toBytes("testtable,$www.hbase.org/,99999"), Bytes.toBytes("fam"), Bytes.toBytes(""), Long.MAX_VALUE, (byte[])null);
        TestKeyValue.assertTrue((KeyValue.META_COMPARATOR.compare(rowA, rowB) < 0 ? 1 : 0) != 0);
    }

    private void metacomparisons(KeyValue.MetaComparator c) {
        long now = System.currentTimeMillis();
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1"), now), new KeyValue(Bytes.toBytes(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1"), now)) == 0 ? 1 : 0) != 0);
        KeyValue a = new KeyValue(Bytes.toBytes(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1"), now);
        KeyValue b = new KeyValue(Bytes.toBytes(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,2"), now);
        TestKeyValue.assertTrue((c.compare(a, b) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,2"), now), new KeyValue(Bytes.toBytes(TableName.META_TABLE_NAME.getNameAsString() + ",a,,0,1"), now)) > 0 ? 1 : 0) != 0);
    }

    private void comparisons(KeyValue.KVComparator c) {
        long now = System.currentTimeMillis();
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes(TableName.META_TABLE_NAME.getNameAsString() + ",,1"), now), new KeyValue(Bytes.toBytes(TableName.META_TABLE_NAME.getNameAsString() + ",,1"), now)) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes(TableName.META_TABLE_NAME.getNameAsString() + ",,1"), now), new KeyValue(Bytes.toBytes(TableName.META_TABLE_NAME.getNameAsString() + ",,2"), now)) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes(TableName.META_TABLE_NAME.getNameAsString() + ",,2"), now), new KeyValue(Bytes.toBytes(TableName.META_TABLE_NAME.getNameAsString() + ",,1"), now)) > 0 ? 1 : 0) != 0);
    }

    public void testBinaryKeys() throws Exception {
        TreeSet set = new TreeSet(KeyValue.COMPARATOR);
        byte[] fam = Bytes.toBytes("col");
        byte[] qf = Bytes.toBytes("umn");
        byte[] nb = new byte[]{};
        KeyValue[] keys2 = new KeyValue[]{new KeyValue(Bytes.toBytes("aaaaa,\u0000\u0000,2"), fam, qf, 2L, nb), new KeyValue(Bytes.toBytes("aaaaa,\u0001,3"), fam, qf, 3L, nb), new KeyValue(Bytes.toBytes("aaaaa,,1"), fam, qf, 1L, nb), new KeyValue(Bytes.toBytes("aaaaa,\u1000,5"), fam, qf, 5L, nb), new KeyValue(Bytes.toBytes("aaaaa,a,4"), fam, qf, 4L, nb), new KeyValue(Bytes.toBytes("a,a,0"), fam, qf, 0L, nb)};
        Collections.addAll(set, keys2);
        boolean assertion = false;
        int count = 0;
        try {
            for (KeyValue k : set) {
                TestKeyValue.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
            }
        }
        catch (AssertionFailedError e) {
            assertion = true;
        }
        TestKeyValue.assertTrue((boolean)assertion);
        set = new TreeSet(new KeyValue.MetaComparator());
        Collections.addAll(set, keys2);
        count = 0;
        for (KeyValue k : set) {
            TestKeyValue.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
        }
    }

    public void testStackedUpKeyValue() {
    }

    private void assertKVLess(KeyValue.KVComparator c, KeyValue less, KeyValue greater) {
        int cmp = c.compare(less, greater);
        TestKeyValue.assertTrue((cmp < 0 ? 1 : 0) != 0);
        cmp = c.compare(greater, less);
        TestKeyValue.assertTrue((cmp > 0 ? 1 : 0) != 0);
    }

    private void assertKVLessWithoutRow(KeyValue.KVComparator c, int common, KeyValue less, KeyValue greater) {
        int cmp = c.compareIgnoringPrefix(common, less.getBuffer(), less.getOffset() + 8, less.getKeyLength(), greater.getBuffer(), greater.getOffset() + 8, greater.getKeyLength());
        TestKeyValue.assertTrue((cmp < 0 ? 1 : 0) != 0);
        cmp = c.compareIgnoringPrefix(common, greater.getBuffer(), greater.getOffset() + 8, greater.getKeyLength(), less.getBuffer(), less.getOffset() + 8, less.getKeyLength());
        TestKeyValue.assertTrue((cmp > 0 ? 1 : 0) != 0);
    }

    public void testCompareWithoutRow() {
        KeyValue.KVComparator c = KeyValue.COMPARATOR;
        byte[] row = Bytes.toBytes("row");
        byte[] fa = Bytes.toBytes("fa");
        byte[] fami = Bytes.toBytes("fami");
        byte[] fami1 = Bytes.toBytes("fami1");
        byte[] qual0 = Bytes.toBytes("");
        byte[] qual1 = Bytes.toBytes("qf1");
        byte[] qual2 = Bytes.toBytes("qf2");
        long ts = 1L;
        KeyValue kv_0 = new KeyValue(row, fa, qual0, ts, KeyValue.Type.Put);
        KeyValue kv0_0 = new KeyValue(row, fami, qual0, ts, KeyValue.Type.Put);
        KeyValue kv0_1 = new KeyValue(row, fami, qual1, ts, KeyValue.Type.Put);
        KeyValue kv0_2 = new KeyValue(row, fami, qual2, ts, KeyValue.Type.Put);
        KeyValue kv1_0 = new KeyValue(row, fami1, qual0, ts, KeyValue.Type.Put);
        this.assertKVLessWithoutRow(c, 0, kv0_1, kv0_2);
        this.assertKVLessWithoutRow(c, 0, kv0_1, kv1_0);
        int commonLength = 3 + row.length;
        this.assertKVLessWithoutRow(c, commonLength + 2, kv_0, kv0_0);
        this.assertKVLessWithoutRow(c, commonLength + 4, kv0_0, kv0_1);
        this.assertKVLessWithoutRow(c, commonLength + 4, kv0_1, kv1_0);
        this.assertKVLessWithoutRow(c, commonLength + 6, kv0_1, kv0_2);
    }

    public void testFirstLastOnRow() {
        KeyValue.KVComparator c = KeyValue.COMPARATOR;
        long ts = 1L;
        byte[] bufferA = new byte[128];
        int offsetA = 0;
        byte[] bufferB = new byte[128];
        int offsetB = 7;
        KeyValue firstOnRowA = KeyValueUtil.createFirstOnRow(this.rowA);
        KeyValue firstOnRowABufferFamQual = KeyValueUtil.createFirstOnRow(bufferA, offsetA, this.rowA, 0, this.rowA.length, this.family, 0, this.family.length, this.qualA, 0, this.qualA.length);
        KeyValue kvA_1 = new KeyValue(this.rowA, null, null, ts, KeyValue.Type.Put);
        KeyValue kvA_2 = new KeyValue(this.rowA, this.family, this.qualA, ts, KeyValue.Type.Put);
        KeyValue lastOnRowA = KeyValueUtil.createLastOnRow(this.rowA);
        KeyValue firstOnRowB = KeyValueUtil.createFirstOnRow(this.rowB);
        KeyValue firstOnRowBBufferFam = KeyValueUtil.createFirstOnRow(bufferB, offsetB, this.rowB, 0, this.rowB.length, this.family, 0, this.family.length, null, 0, 0);
        KeyValue kvB = new KeyValue(this.rowB, this.family, this.qualA, ts, KeyValue.Type.Put);
        this.assertKVLess(c, firstOnRowA, firstOnRowB);
        this.assertKVLess(c, firstOnRowA, firstOnRowBBufferFam);
        this.assertKVLess(c, firstOnRowABufferFamQual, firstOnRowB);
        this.assertKVLess(c, firstOnRowA, kvA_1);
        this.assertKVLess(c, firstOnRowA, kvA_2);
        this.assertKVLess(c, firstOnRowABufferFamQual, kvA_2);
        this.assertKVLess(c, kvA_1, kvA_2);
        this.assertKVLess(c, kvA_2, firstOnRowB);
        this.assertKVLess(c, kvA_1, firstOnRowB);
        this.assertKVLess(c, kvA_2, firstOnRowBBufferFam);
        this.assertKVLess(c, kvA_1, firstOnRowBBufferFam);
        this.assertKVLess(c, lastOnRowA, firstOnRowB);
        this.assertKVLess(c, lastOnRowA, firstOnRowBBufferFam);
        this.assertKVLess(c, firstOnRowB, kvB);
        this.assertKVLess(c, firstOnRowBBufferFam, kvB);
        this.assertKVLess(c, lastOnRowA, kvB);
        this.assertKVLess(c, kvA_2, lastOnRowA);
        this.assertKVLess(c, kvA_1, lastOnRowA);
        this.assertKVLess(c, firstOnRowA, lastOnRowA);
        this.assertKVLess(c, firstOnRowABufferFamQual, lastOnRowA);
    }

    public void testCreateKeyOnly() throws Exception {
        long ts = 1L;
        byte[] value = Bytes.toBytes("a real value");
        byte[] evalue = new byte[]{};
        for (byte[] val : new byte[][]{value, evalue}) {
            for (boolean useLen : new boolean[]{false, true}) {
                KeyValue kv1 = new KeyValue(this.rowA, this.family, this.qualA, ts, val);
                KeyValue kv1ko = kv1.createKeyOnly(useLen);
                TestKeyValue.assertTrue((boolean)kv1.equals(kv1ko));
                TestKeyValue.assertTrue((kv1ko.getValue().length == (useLen ? 4 : 0) ? 1 : 0) != 0);
                if (!useLen) continue;
                TestKeyValue.assertEquals((int)kv1.getValueLength(), (int)Bytes.toInt(kv1ko.getValue()));
            }
        }
    }

    public void testCreateKeyValueFromKey() {
        KeyValue kv = new KeyValue(Bytes.toBytes("myRow"), Bytes.toBytes("myCF"), Bytes.toBytes("myQualifier"), 12345L, Bytes.toBytes("myValue"));
        int initialPadding = 10;
        int endingPadding = 20;
        int keyLen = kv.getKeyLength();
        byte[] tmpArr = new byte[initialPadding + endingPadding + keyLen];
        System.arraycopy(kv.getBuffer(), kv.getKeyOffset(), tmpArr, initialPadding, keyLen);
        KeyValue kvFromKey = KeyValue.createKeyValueFromKey(tmpArr, initialPadding, keyLen);
        TestKeyValue.assertEquals((int)keyLen, (int)kvFromKey.getKeyLength());
        TestKeyValue.assertEquals((int)(8 + keyLen), (int)kvFromKey.getBuffer().length);
        System.err.println("kv=" + kv);
        System.err.println("kvFromKey=" + kvFromKey);
        TestKeyValue.assertEquals((String)kvFromKey.toString(), (String)kv.toString().replaceAll("=[0-9]+", "=0"));
    }

    public void testGetTimestamp() {
        KeyValue kv = new KeyValue(Bytes.toBytes("myRow"), Bytes.toBytes("myCF"), Bytes.toBytes("myQualifier"), Long.MAX_VALUE, Bytes.toBytes("myValue"));
        long time1 = kv.getTimestamp();
        kv.updateLatestStamp(Bytes.toBytes(12345L));
        long time2 = kv.getTimestamp();
        TestKeyValue.assertEquals((long)Long.MAX_VALUE, (long)time1);
        TestKeyValue.assertEquals((long)12345L, (long)time2);
    }

    public void testGetShortMidpointKey() {
        KeyValue.KVComparator keyComparator = KeyValue.COMPARATOR;
        long ts = 5L;
        KeyValue kv1 = new KeyValue(Bytes.toBytes("the quick brown fox"), this.family, this.qualA, ts, KeyValue.Type.Put);
        KeyValue kv2 = new KeyValue(Bytes.toBytes("the who test text"), this.family, this.qualA, ts, KeyValue.Type.Put);
        byte[] newKey = keyComparator.getShortMidpointKey(kv1.getKey(), kv2.getKey());
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), newKey) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(newKey, kv2.getKey()) < 0 ? 1 : 0) != 0);
        short newRowLength = Bytes.toShort(newKey, 0);
        byte[] expectedArray = Bytes.toBytes("the r");
        Bytes.equals(newKey, 2, newRowLength, expectedArray, 0, expectedArray.length);
        kv1 = new KeyValue(Bytes.toBytes("ilovehbase"), this.family, this.qualA, 5L, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes("ilovehbase"), this.family, this.qualA, 0L, KeyValue.Type.Put);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), kv2.getKey()) < 0 ? 1 : 0) != 0);
        newKey = keyComparator.getShortMidpointKey(kv1.getKey(), kv2.getKey());
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), newKey) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(newKey, kv2.getKey()) == 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(Bytes.toBytes("ilovehbase"), this.family, this.qualA, -5L, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes("ilovehbase"), this.family, this.qualA, -10L, KeyValue.Type.Put);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), kv2.getKey()) < 0 ? 1 : 0) != 0);
        newKey = keyComparator.getShortMidpointKey(kv1.getKey(), kv2.getKey());
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), newKey) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(newKey, kv2.getKey()) == 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(Bytes.toBytes("ilovehbase"), this.family, this.qualA, 5L, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes("ilovehbase"), this.family, this.qualB, 5L, KeyValue.Type.Put);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), kv2.getKey()) < 0 ? 1 : 0) != 0);
        newKey = keyComparator.getShortMidpointKey(kv1.getKey(), kv2.getKey());
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), newKey) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(newKey, kv2.getKey()) < 0 ? 1 : 0) != 0);
        KeyValue newKeyValue = KeyValue.createKeyValueFromKey(newKey);
        TestKeyValue.assertTrue((boolean)Arrays.equals(newKeyValue.getFamily(), this.family));
        TestKeyValue.assertTrue((boolean)Arrays.equals(newKeyValue.getQualifier(), this.qualB));
        TestKeyValue.assertTrue((newKeyValue.getTimestamp() == Long.MAX_VALUE ? 1 : 0) != 0);
        TestKeyValue.assertTrue((newKeyValue.getTypeByte() == KeyValue.Type.Maximum.getCode() ? 1 : 0) != 0);
        KeyValue.KVComparator metaKeyComparator = KeyValue.META_COMPARATOR;
        kv1 = new KeyValue(Bytes.toBytes("ilovehbase123"), this.family, this.qualA, 5L, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes("ilovehbase234"), this.family, this.qualA, 0L, KeyValue.Type.Put);
        newKey = metaKeyComparator.getShortMidpointKey(kv1.getKey(), kv2.getKey());
        TestKeyValue.assertTrue((metaKeyComparator.compareFlatKey(kv1.getKey(), newKey) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((metaKeyComparator.compareFlatKey(newKey, kv2.getKey()) == 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(Bytes.toBytes("ilovehbase"), this.family, this.qualA, ts, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes("ilovehbaseandhdfs"), this.family, this.qualA, ts, KeyValue.Type.Put);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), kv2.getKey()) < 0 ? 1 : 0) != 0);
        newKey = keyComparator.getShortMidpointKey(kv1.getKey(), kv2.getKey());
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), newKey) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(newKey, kv2.getKey()) < 0 ? 1 : 0) != 0);
        newRowLength = Bytes.toShort(newKey, 0);
        expectedArray = Bytes.toBytes("ilovehbasea");
        Bytes.equals(newKey, 2, newRowLength, expectedArray, 0, expectedArray.length);
        kv1 = new KeyValue(Bytes.toBytes("100abcdefg"), this.family, this.qualA, ts, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes("101abcdefg"), this.family, this.qualA, ts, KeyValue.Type.Put);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), kv2.getKey()) < 0 ? 1 : 0) != 0);
        newKey = keyComparator.getShortMidpointKey(kv1.getKey(), kv2.getKey());
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(kv1.getKey(), newKey) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((keyComparator.compareFlatKey(newKey, kv2.getKey()) < 0 ? 1 : 0) != 0);
        newRowLength = Bytes.toShort(newKey, 0);
        expectedArray = Bytes.toBytes("101");
        Bytes.equals(newKey, 2, newRowLength, expectedArray, 0, expectedArray.length);
    }

    public void testKVsWithTags() {
        byte[] row = Bytes.toBytes("myRow");
        byte[] cf = Bytes.toBytes("myCF");
        byte[] q = Bytes.toBytes("myQualifier");
        byte[] value = Bytes.toBytes("myValue");
        byte[] metaValue1 = Bytes.toBytes("metaValue1");
        byte[] metaValue2 = Bytes.toBytes("metaValue2");
        KeyValue kv = new KeyValue(row, cf, q, Long.MAX_VALUE, value, new Tag[]{new Tag(1, metaValue1), new Tag(2, metaValue2)});
        TestKeyValue.assertTrue((kv.getTagsLength() > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((boolean)Bytes.equals(kv.getRow(), row));
        TestKeyValue.assertTrue((boolean)Bytes.equals(kv.getFamily(), cf));
        TestKeyValue.assertTrue((boolean)Bytes.equals(kv.getQualifier(), q));
        TestKeyValue.assertTrue((boolean)Bytes.equals(kv.getValue(), value));
        List<Tag> tags = kv.getTags();
        TestKeyValue.assertNotNull(tags);
        TestKeyValue.assertEquals((int)2, (int)tags.size());
        boolean meta1Ok = false;
        boolean meta2Ok = false;
        for (Tag tag : tags) {
            if (tag.getType() == 1) {
                if (!Bytes.equals(tag.getValue(), metaValue1)) continue;
                meta1Ok = true;
                continue;
            }
            if (!Bytes.equals(tag.getValue(), metaValue2)) continue;
            meta2Ok = true;
        }
        TestKeyValue.assertTrue((boolean)meta1Ok);
        TestKeyValue.assertTrue((boolean)meta2Ok);
        Iterator<Tag> tagItr = CellUtil.tagsIterator(kv.getTagsArray(), kv.getTagsOffset(), kv.getTagsLength());
        TestKeyValue.assertTrue((boolean)tagItr.hasNext());
        Tag next = tagItr.next();
        TestKeyValue.assertEquals((int)10, (int)next.getTagLength());
        TestKeyValue.assertEquals((byte)1, (byte)next.getType());
        Bytes.equals(next.getValue(), metaValue1);
        TestKeyValue.assertTrue((boolean)tagItr.hasNext());
        next = tagItr.next();
        TestKeyValue.assertEquals((int)10, (int)next.getTagLength());
        TestKeyValue.assertEquals((byte)2, (byte)next.getType());
        Bytes.equals(next.getValue(), metaValue2);
        TestKeyValue.assertFalse((boolean)tagItr.hasNext());
        tagItr = CellUtil.tagsIterator(kv.getTagsArray(), kv.getTagsOffset(), kv.getTagsLength());
        TestKeyValue.assertTrue((boolean)tagItr.hasNext());
        next = tagItr.next();
        TestKeyValue.assertEquals((int)10, (int)next.getTagLength());
        TestKeyValue.assertEquals((byte)1, (byte)next.getType());
        Bytes.equals(next.getValue(), metaValue1);
        TestKeyValue.assertTrue((boolean)tagItr.hasNext());
        next = tagItr.next();
        TestKeyValue.assertEquals((int)10, (int)next.getTagLength());
        TestKeyValue.assertEquals((byte)2, (byte)next.getType());
        Bytes.equals(next.getValue(), metaValue2);
        TestKeyValue.assertFalse((boolean)tagItr.hasNext());
    }

    public void testMetaKeyComparator() {
        KeyValue b;
        KeyValue.MetaComparator c = new KeyValue.MetaComparator();
        long now = System.currentTimeMillis();
        KeyValue a = new KeyValue(Bytes.toBytes("table1"), now);
        TestKeyValue.assertTrue((c.compare(a, b = new KeyValue(Bytes.toBytes("table2"), now)) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes("table1,111"), now);
        b = new KeyValue(Bytes.toBytes("table2"), now);
        TestKeyValue.assertTrue((c.compare(a, b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes("table1"), now);
        b = new KeyValue(Bytes.toBytes("table2,111"), now);
        TestKeyValue.assertTrue((c.compare(a, b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes("table,111"), now);
        b = new KeyValue(Bytes.toBytes("table,2222"), now);
        TestKeyValue.assertTrue((c.compare(a, b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes("table,111,aaaa"), now);
        b = new KeyValue(Bytes.toBytes("table,2222"), now);
        TestKeyValue.assertTrue((c.compare(a, b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes("table,111"), now);
        b = new KeyValue(Bytes.toBytes("table,2222.bbb"), now);
        TestKeyValue.assertTrue((c.compare(a, b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes("table,,aaaa"), now);
        b = new KeyValue(Bytes.toBytes("table,111,bbb"), now);
        TestKeyValue.assertTrue((c.compare(a, b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes("table,111,aaaa"), now);
        b = new KeyValue(Bytes.toBytes("table,111,bbb"), now);
        TestKeyValue.assertTrue((c.compare(a, b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes("table,111,xxxx"), now);
        b = new KeyValue(Bytes.toBytes("table,111,222,bbb"), now);
        TestKeyValue.assertTrue((c.compare(a, b) < 0 ? 1 : 0) != 0);
        a = new KeyValue(Bytes.toBytes("table,111,11,xxx"), now);
        b = new KeyValue(Bytes.toBytes("table,111,222,bbb"), now);
        TestKeyValue.assertTrue((c.compare(a, b) < 0 ? 1 : 0) != 0);
    }

    public void testKeyValueSerialization() throws Exception {
        KeyValue kvA1 = new KeyValue(Bytes.toBytes("key"), Bytes.toBytes("cf"), Bytes.toBytes("qualA"), Bytes.toBytes("1"));
        KeyValue kvA2 = new KeyValue(Bytes.toBytes("key"), Bytes.toBytes("cf"), Bytes.toBytes("qualA"), Bytes.toBytes("2"));
        MockKeyValue mkvA1 = new MockKeyValue(kvA1);
        MockKeyValue mkvA2 = new MockKeyValue(kvA2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(byteArrayOutputStream);
        KeyValueUtil.oswrite(mkvA1, os, true);
        KeyValueUtil.oswrite(mkvA2, os, true);
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        KeyValue deSerKV1 = KeyValue.iscreate(is);
        TestKeyValue.assertTrue((boolean)kvA1.equals(deSerKV1));
        KeyValue deSerKV2 = KeyValue.iscreate(is);
        TestKeyValue.assertTrue((boolean)kvA2.equals(deSerKV2));
    }

    public void testEqualsAndHashCode() throws Exception {
        KeyValue kvA1 = new KeyValue(Bytes.toBytes("key"), Bytes.toBytes("cf"), Bytes.toBytes("qualA"), Bytes.toBytes("1"));
        KeyValue kvA2 = new KeyValue(Bytes.toBytes("key"), Bytes.toBytes("cf"), Bytes.toBytes("qualA"), Bytes.toBytes("2"));
        kvA2.setSequenceId(2L);
        KeyValue kvB = new KeyValue(Bytes.toBytes("key"), Bytes.toBytes("cf"), Bytes.toBytes("qualB"), Bytes.toBytes("1"));
        TestKeyValue.assertEquals((Object)kvA1, (Object)kvA2);
        Assert.assertNotEquals((Object)kvA1, (Object)kvB);
        TestKeyValue.assertEquals((int)kvA1.hashCode(), (int)kvA2.hashCode());
        Assert.assertNotEquals((long)kvA1.hashCode(), (long)kvB.hashCode());
    }

    private class MockKeyValue
    implements Cell {
        private final KeyValue kv;

        public MockKeyValue(KeyValue kv) {
            this.kv = kv;
        }

        @Override
        public int getTagsOffset() {
            return this.kv.getTagsOffset();
        }

        @Override
        public long getMvccVersion() {
            return this.kv.getMvccVersion();
        }

        @Override
        public long getSequenceId() {
            return this.kv.getSequenceId();
        }

        @Override
        public int getTagsLength() {
            return this.kv.getTagsLength();
        }

        @Override
        public long getTimestamp() {
            return this.kv.getTimestamp();
        }

        @Override
        public byte getTypeByte() {
            return this.kv.getTypeByte();
        }

        @Override
        public byte[] getValueArray() {
            return this.kv.getValueArray();
        }

        @Override
        public int getValueOffset() {
            return this.kv.getValueOffset();
        }

        @Override
        public int getValueLength() {
            return this.kv.getValueLength();
        }

        @Override
        public byte[] getRowArray() {
            return this.kv.getRowArray();
        }

        @Override
        public int getRowOffset() {
            return this.kv.getRowOffset();
        }

        @Override
        public short getRowLength() {
            return this.kv.getRowLength();
        }

        @Override
        public byte[] getFamilyArray() {
            return this.kv.getFamilyArray();
        }

        @Override
        public int getFamilyOffset() {
            return this.kv.getFamilyOffset();
        }

        @Override
        public byte getFamilyLength() {
            return this.kv.getFamilyLength();
        }

        @Override
        public byte[] getQualifierArray() {
            return this.kv.getQualifierArray();
        }

        @Override
        public int getQualifierOffset() {
            return this.kv.getQualifierOffset();
        }

        @Override
        public int getQualifierLength() {
            return this.kv.getQualifierLength();
        }

        @Override
        @Deprecated
        public byte[] getValue() {
            return null;
        }

        @Override
        @Deprecated
        public byte[] getFamily() {
            return null;
        }

        @Override
        @Deprecated
        public byte[] getQualifier() {
            return null;
        }

        @Override
        @Deprecated
        public byte[] getRow() {
            return null;
        }

        @Override
        public byte[] getTagsArray() {
            return this.kv.getTagsArray();
        }
    }
}

