/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.AvroConversionHelper$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.spark.org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class AvroConversionUtils$ {
    public static final AvroConversionUtils$ MODULE$;

    static {
        new AvroConversionUtils$();
    }

    public Dataset<Row> createDataFrame(RDD<GenericRecord> rdd, String schemaStr, SparkSession ss) {
        return rdd.isEmpty() ? ss.emptyDataFrame() : ss.createDataFrame(rdd.mapPartitions((Function1)new Serializable(schemaStr){
            public static final long serialVersionUID = 0L;
            private final String schemaStr$1;

            public final Iterator<Row> apply(Iterator<GenericRecord> records) {
                Iterator iterator2;
                if (records.isEmpty()) {
                    iterator2 = package$.MODULE$.Iterator().empty();
                } else {
                    Schema schema2 = new Schema.Parser().parse(this.schemaStr$1);
                    StructType dataType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema2);
                    Function1<Object, Object> convertor = AvroConversionHelper$.MODULE$.createConverterToRow(schema2, (DataType)dataType);
                    iterator2 = records.map((Function1)new Serializable(this, convertor){
                        public static final long serialVersionUID = 0L;
                        private final Function1 convertor$1;

                        public final Row apply(GenericRecord x) {
                            return (Row)this.convertor$1.apply((Object)x);
                        }
                        {
                            this.convertor$1 = convertor$1;
                        }
                    });
                }
                return iterator2;
            }
            {
                this.schemaStr$1 = schemaStr$1;
            }
        }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class)), this.convertAvroSchemaToStructType(new Schema.Parser().parse(schemaStr)));
    }

    public Schema convertStructTypeToAvroSchema(StructType structType, String structName, String recordNamespace) {
        return SchemaConverters$.MODULE$.toAvroType((DataType)structType, false, structName, recordNamespace);
    }

    public StructType convertAvroSchemaToStructType(Schema avroSchema) {
        return (StructType)SchemaConverters$.MODULE$.toSqlType(avroSchema).dataType();
    }

    public GenericRecord buildAvroRecordBySchema(IndexedRecord record, Schema requiredSchema, List<Object> requiredPos, GenericRecordBuilder recordBuilder) {
        Buffer requiredFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(requiredSchema.getFields()).asScala();
        Predef$.MODULE$.assert(requiredFields.length() == requiredPos.length());
        Iterator positionIterator = requiredPos.iterator();
        requiredFields.foreach((Function1)new Serializable(record, recordBuilder, positionIterator){
            public static final long serialVersionUID = 0L;
            private final IndexedRecord record$1;
            private final GenericRecordBuilder recordBuilder$1;
            private final Iterator positionIterator$1;

            public final GenericRecordBuilder apply(Schema.Field f) {
                return this.recordBuilder$1.set(f, this.record$1.get(BoxesRunTime.unboxToInt((Object)this.positionIterator$1.next())));
            }
            {
                this.record$1 = record$1;
                this.recordBuilder$1 = recordBuilder$1;
                this.positionIterator$1 = positionIterator$1;
            }
        });
        return recordBuilder.build();
    }

    public Tuple2<String, String> getAvroRecordNameAndNamespace(String tableName) {
        String name = HoodieAvroUtils.sanitizeName(tableName);
        return new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_record"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
    }

    private AvroConversionUtils$() {
        MODULE$ = this;
    }
}

