/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieBootstrapRelation;
import org.apache.hudi.HoodieEmptyRelation;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.HoodieStreamingSink;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.IncrementalRelation;
import org.apache.hudi.MergeOnReadIncrementalRelation;
import org.apache.hudi.MergeOnReadSnapshotRelation;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.HoodieROTablePathFilter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.hudi.streaming.HoodieStreamSource;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.sources.StreamSinkProvider;
import org.apache.spark.sql.sources.StreamSourceProvider;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0001\u0003\u0001%\u0011Q\u0002R3gCVdGoU8ve\u000e,'BA\u0002\u0005\u0003\u0011AW\u000fZ5\u000b\u0005\u00151\u0011AB1qC\u000eDWMC\u0001\b\u0003\ry'oZ\u0002\u0001'%\u0001!\u0002\u0005\u000e\u001eA\r2\u0013\u0006\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\t\u0003#ai\u0011A\u0005\u0006\u0003'Q\tqa]8ve\u000e,7O\u0003\u0002\u0016-\u0005\u00191/\u001d7\u000b\u0005]!\u0011!B:qCJ\\\u0017BA\r\u0013\u0005A\u0011V\r\\1uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002\u00127%\u0011AD\u0005\u0002\u0017'\u000eDW-\\1SK2\fG/[8o!J|g/\u001b3feB\u0011\u0011CH\u0005\u0003?I\u0011\u0011d\u0011:fCR\f'\r\\3SK2\fG/[8o!J|g/\u001b3feB\u0011\u0011#I\u0005\u0003EI\u0011!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011\u0011\u0003J\u0005\u0003KI\u0011!c\u0015;sK\u0006l7+\u001b8l!J|g/\u001b3feB\u0011\u0011cJ\u0005\u0003QI\u0011Ac\u0015;sK\u0006l7k\\;sG\u0016\u0004&o\u001c<jI\u0016\u0014\bCA\u0006+\u0013\tYCB\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003.\u0001\u0011\u0005a&\u0001\u0004=S:LGO\u0010\u000b\u0002_A\u0011\u0001\u0007A\u0007\u0002\u0005!9!\u0007\u0001b\u0001\n\u0013\u0019\u0014a\u00017pOV\tA\u0007\u0005\u00026q5\taG\u0003\u00028\t\u0005)An\\45U&\u0011\u0011H\u000e\u0002\u0007\u0019><w-\u001a:\t\rm\u0002\u0001\u0015!\u00035\u0003\u0011awn\u001a\u0011\t\u000bu\u0002A\u0011\t \u0002\u001d\r\u0014X-\u0019;f%\u0016d\u0017\r^5p]R\u0019qH\u0011%\u0011\u0005E\u0001\u0015BA!\u0013\u00051\u0011\u0015m]3SK2\fG/[8o\u0011\u0015\u0019E\b1\u0001E\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003\u000b\u001ak\u0011\u0001F\u0005\u0003\u000fR\u0011!bU)M\u0007>tG/\u001a=u\u0011\u0015IE\b1\u0001K\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005\u0017:\u000b\u0016K\u0004\u0002\f\u0019&\u0011Q\nD\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&aA'ba*\u0011Q\n\u0004\t\u0003\u0017JK!a\u0015)\u0003\rM#(/\u001b8h\u0011\u0015i\u0004\u0001\"\u0011V)\u0011ydkV-\t\u000b\r#\u0006\u0019\u0001#\t\u000ba#\u0006\u0019\u0001&\u0002\u0013=\u0004H\u000fU1sC6\u001c\b\"\u0002.U\u0001\u0004Y\u0016AB:dQ\u0016l\u0017\r\u0005\u0002]?6\tQL\u0003\u0002_)\u0005)A/\u001f9fg&\u0011\u0001-\u0018\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"B\u001f\u0001\t\u0003\u0012G#B dI&T\u0007\"B\"b\u0001\u0004!\u0005\"B3b\u0001\u00041\u0017\u0001B7pI\u0016\u0004\"!R4\n\u0005!$\"\u0001C*bm\u0016lu\u000eZ3\t\u000ba\u000b\u0007\u0019\u0001&\t\u000b-\f\u0007\u0019\u00017\u0002\u0005\u00114\u0007CA7|\u001d\tq\u0017P\u0004\u0002pq:\u0011\u0001o\u001e\b\u0003cZt!A];\u000e\u0003MT!\u0001\u001e\u0005\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0011BA\u0003\u0007\u0013\t9B!\u0003\u0002\u0016-%\u0011!\u0010F\u0001\ba\u0006\u001c7.Y4f\u0013\taXPA\u0005ECR\fgI]1nK*\u0011!\u0010\u0006\u0005\u0007\u007f\u0002!\t%!\u0001\u0002\u0015\r\u0014X-\u0019;f'&t7\u000e\u0006\u0006\u0002\u0004\u0005M\u0011QCA\f\u0003W\u0001B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!A\u0005tiJ,\u0017-\\5oO*\u0019\u0011Q\u0002\u000b\u0002\u0013\u0015DXmY;uS>t\u0017\u0002BA\t\u0003\u000f\u0011AaU5oW\")1I a\u0001\t\")\u0001L a\u0001\u0015\"9\u0011\u0011\u0004@A\u0002\u0005m\u0011\u0001\u00059beRLG/[8o\u0007>dW/\u001c8t!\u0015\ti\"!\nR\u001d\u0011\ty\"a\t\u000f\u0007I\f\t#C\u0001\u000e\u0013\tQH\"\u0003\u0003\u0002(\u0005%\"aA*fc*\u0011!\u0010\u0004\u0005\b\u0003[q\b\u0019AA\u0018\u0003)yW\u000f\u001e9vi6{G-\u001a\t\u0005\u0003c\t)$\u0004\u0002\u00024)\u0019\u0011\u0011\u0002\u000b\n\t\u0005]\u00121\u0007\u0002\u000b\u001fV$\b/\u001e;N_\u0012,\u0007bBA\u001e\u0001\u0011\u0005\u0013QH\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012!\u0015\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0003M9W\r\u001e\"bg\u00164\u0015\u000e\\3P]2Lh+[3x)=y\u0014QIA$\u0003\u0013\nY%a\u0014\u0002Z\u0005=\u0004BB\"\u0002@\u0001\u0007A\t\u0003\u0004Y\u0003\u007f\u0001\rA\u0013\u0005\u00075\u0006}\u0002\u0019A.\t\u0011\u00055\u0013q\ba\u0001\u00037\ta\"\u001a=ue\u0006\u0014V-\u00193QCRD7\u000f\u0003\u0005\u0002R\u0005}\u0002\u0019AA*\u0003MI7OQ8piN$(/\u00199qK\u0012$\u0016M\u00197f!\rY\u0011QK\u0005\u0004\u0003/b!a\u0002\"p_2,\u0017M\u001c\u0005\t\u00037\ny\u00041\u0001\u0002^\u0005Iq\r\\8c!\u0006$\bn\u001d\t\u0007\u0003;\t)#a\u0018\u0011\t\u0005\u0005\u00141N\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005\u0011am\u001d\u0006\u0004\u0003S\"\u0011A\u00025bI>|\u0007/\u0003\u0003\u0002n\u0005\r$\u0001\u0002)bi\"D\u0001\"!\u001d\u0002@\u0001\u0007\u00111O\u0001\u000b[\u0016$\u0018m\u00117jK:$\b\u0003BA;\u0003\u007fj!!a\u001e\u000b\t\u0005e\u00141P\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0004\u0003{\u0012\u0011AB2p[6|g.\u0003\u0003\u0002\u0002\u0006]$!\u0006%p_\u0012LW\rV1cY\u0016lU\r^1DY&,g\u000e\u001e\u0005\b\u0003\u000b\u0003A\u0011IAD\u00031\u0019x.\u001e:dKN\u001b\u0007.Z7b))\tI)a$\u0002\u0012\u0006e\u0015Q\u0014\t\u0006\u0017\u0005-\u0015kW\u0005\u0004\u0003\u001bc!A\u0002+va2,'\u0007\u0003\u0004D\u0003\u0007\u0003\r\u0001\u0012\u0005\b5\u0006\r\u0005\u0019AAJ!\u0011Y\u0011QS.\n\u0007\u0005]EB\u0001\u0004PaRLwN\u001c\u0005\b\u00037\u000b\u0019\t1\u0001R\u00031\u0001(o\u001c<jI\u0016\u0014h*Y7f\u0011\u0019I\u00151\u0011a\u0001\u0015\"9\u0011\u0011\u0015\u0001\u0005B\u0005\r\u0016\u0001D2sK\u0006$XmU8ve\u000e,G\u0003DAS\u0003W\u000bi+!-\u00024\u0006U\u0006\u0003BA\u0003\u0003OKA!!+\u0002\b\t11k\\;sG\u0016DaaQAP\u0001\u0004!\u0005bBAX\u0003?\u0003\r!U\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\u0005\b5\u0006}\u0005\u0019AAJ\u0011\u001d\tY*a(A\u0002ECa!SAP\u0001\u0004Q\u0005")
public class DefaultSource
implements RelationProvider,
SchemaRelationProvider,
CreatableRelationProvider,
DataSourceRegister,
StreamSinkProvider,
StreamSourceProvider,
Serializable {
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        return this.createRelation(sqlContext, parameters, null);
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> optParams, StructType schema2) {
        Map<String, String> parameters;
        block11: {
            BaseRelation baseRelation;
            block9: {
                String tablePath;
                FileSystem fs;
                block10: {
                    boolean isBootstrappedTable;
                    HoodieTableMetaClient metaClient;
                    Seq<Path> globPaths;
                    Seq readPaths;
                    block8: {
                        parameters = DataSourceReadOptions$.MODULE$.translateViewTypesToQueryTypes(optParams);
                        scala.Option path = parameters.get((Object)"path");
                        scala.Option readPathsStr = parameters.get((Object)DataSourceReadOptions$.MODULE$.READ_PATHS_OPT_KEY());
                        if (path.isEmpty() && readPathsStr.isEmpty()) {
                            throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'path' or '", "' or both must be specified."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceReadOptions$.MODULE$.READ_PATHS_OPT_KEY()})));
                        }
                        readPaths = (Seq)readPathsStr.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<String> apply(String p) {
                                return Predef$.MODULE$.refArrayOps((Object[])p.split(",")).toSeq();
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<Nothing$> apply() {
                                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                            }
                        });
                        Seq allPaths = (Seq)((TraversableLike)path.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<String> apply(String p) {
                                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{p}));
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<Nothing$> apply() {
                                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                            }
                        })).$plus$plus((GenTraversableOnce)readPaths, Seq$.MODULE$.canBuildFrom());
                        fs = FSUtils.getFs((String)allPaths.head(), sqlContext.sparkContext().hadoopConfiguration());
                        globPaths = HoodieSparkUtils$.MODULE$.checkAndGlobPathIfNecessary((Seq<String>)allPaths, fs);
                        tablePath = DataSourceUtils.getTablePath(fs, (Path[])globPaths.toArray(ClassTag$.MODULE$.apply(Path.class)));
                        this.log().info((Object)new StringBuilder().append((Object)"Obtained hudi table path: ").append((Object)tablePath).toString());
                        metaClient = HoodieTableMetaClient.builder().setConf(fs.getConf()).setBasePath(tablePath).build();
                        isBootstrappedTable = metaClient.getTableConfig().getBootstrapBasePath().isPresent();
                        this.log().info((Object)new StringBuilder().append((Object)"Is bootstrapped table => ").append((Object)BoxesRunTime.boxToBoolean((boolean)isBootstrappedTable)).toString());
                        if (!((String)parameters.apply((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_OPT_KEY())).equals(DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL())) break block8;
                        if (metaClient.getTableType().equals((Object)HoodieTableType.MERGE_ON_READ)) {
                            if (isBootstrappedTable) {
                                this.log().warn((Object)"Snapshot query is not supported for Bootstrapped Merge-on-Read tables. Falling back to Read Optimized query.");
                                baseRelation = new HoodieBootstrapRelation(sqlContext, schema2, globPaths, metaClient, optParams);
                            } else {
                                baseRelation = new MergeOnReadSnapshotRelation(sqlContext, optParams, schema2, globPaths, metaClient);
                            }
                        } else {
                            baseRelation = this.getBaseFileOnlyView(sqlContext, parameters, schema2, (Seq<String>)readPaths, isBootstrappedTable, globPaths, metaClient);
                        }
                        break block9;
                    }
                    if (!((String)parameters.apply((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_OPT_KEY())).equals(DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL())) break block10;
                    baseRelation = this.getBaseFileOnlyView(sqlContext, parameters, schema2, (Seq<String>)readPaths, isBootstrappedTable, globPaths, metaClient);
                    break block9;
                }
                if (!((String)parameters.apply((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_OPT_KEY())).equals(DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL())) break block11;
                HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(fs.getConf()).setBasePath(tablePath).build();
                baseRelation = metaClient.getTableType().equals((Object)HoodieTableType.MERGE_ON_READ) ? new MergeOnReadIncrementalRelation(sqlContext, optParams, schema2, metaClient) : new IncrementalRelation(sqlContext, optParams, schema2, metaClient);
            }
            return baseRelation;
        }
        throw new HoodieException(new StringBuilder().append((Object)"Invalid query type :").append(parameters.apply((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_OPT_KEY())).toString());
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> optParams, Dataset<Row> df) {
        Map<String, String> parameters = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(optParams);
        Map<String, String> translatedOptions = DataSourceWriteOptions$.MODULE$.translateSqlOptions(parameters);
        Dataset dfWithoutMetaCols = df.drop((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala());
        Tuple5<Object, Option<String>, Option<String>, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, HoodieTableConfig> tuple5 = ((String)translatedOptions.apply((Object)DataSourceWriteOptions$.MODULE$.OPERATION_OPT_KEY())).equals(DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()) ? BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.MODULE$.bootstrap(sqlContext, mode, translatedOptions, (Dataset<Row>)dfWithoutMetaCols, HoodieSparkSqlWriter$.MODULE$.bootstrap$default$5(), HoodieSparkSqlWriter$.MODULE$.bootstrap$default$6())) : HoodieSparkSqlWriter$.MODULE$.write(sqlContext, mode, translatedOptions, (Dataset<Row>)dfWithoutMetaCols, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7());
        return new HoodieEmptyRelation(sqlContext, dfWithoutMetaCols.schema());
    }

    public Sink createSink(SQLContext sqlContext, Map<String, String> optParams, Seq<String> partitionColumns, OutputMode outputMode) {
        Map<String, String> parameters = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(optParams);
        Map<String, String> translatedOptions = DataSourceWriteOptions$.MODULE$.translateSqlOptions(parameters);
        return new HoodieStreamingSink(sqlContext, translatedOptions, partitionColumns, outputMode);
    }

    public String shortName() {
        return "hudi";
    }

    private BaseRelation getBaseFileOnlyView(SQLContext sqlContext, Map<String, String> optParams, StructType schema2, Seq<String> extraReadPaths, boolean isBootstrappedTable, Seq<Path> globPaths, HoodieTableMetaClient metaClient) {
        HoodieBootstrapRelation hoodieBootstrapRelation;
        this.log().warn((Object)"Loading Base File Only View.");
        if (isBootstrappedTable) {
            hoodieBootstrapRelation = new HoodieBootstrapRelation(sqlContext, schema2, globPaths, metaClient, optParams);
        } else {
            sqlContext.sparkContext().hadoopConfiguration().setClass("mapreduce.input.pathFilter.class", HoodieROTablePathFilter.class, PathFilter.class);
            this.log().info((Object)new StringBuilder().append((Object)"Constructing hoodie (as parquet) data source with options :").append(optParams).toString());
            SparkSession x$1 = sqlContext.sparkSession();
            Seq<String> x$2 = extraReadPaths;
            scala.Option x$3 = Option$.MODULE$.apply((Object)schema2);
            String x$4 = "parquet";
            Map<String, String> x$5 = optParams;
            Seq x$6 = DataSource$.MODULE$.apply$default$5();
            scala.Option x$7 = DataSource$.MODULE$.apply$default$6();
            scala.Option x$8 = DataSource$.MODULE$.apply$default$8();
            DataSource qual$1 = new DataSource(x$1, x$4, x$2, x$3, x$6, x$7, x$5, x$8);
            boolean x$9 = qual$1.resolveRelation$default$1();
            hoodieBootstrapRelation = qual$1.resolveRelation(x$9);
        }
        return hoodieBootstrapRelation;
    }

    public Tuple2<String, StructType> sourceSchema(SQLContext sqlContext, scala.Option<StructType> schema2, String providerName, Map<String, String> parameters) {
        StructType structType;
        scala.Option path = parameters.get((Object)"path");
        if (path.isEmpty() || path.get() == null) {
            throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'path'  must be specified."})).s((Seq)Nil$.MODULE$));
        }
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(sqlContext.sparkSession().sessionState().newHadoopConf()).setBasePath((String)path.get()).build();
        TableSchemaResolver schemaResolver = new TableSchemaResolver(metaClient);
        try {
            Schema avroSchema = schemaResolver.getTableAvroSchema();
            structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(avroSchema);
        }
        catch (Exception exception) {
            Predef$.MODULE$.require(schema2.isDefined(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Fail to resolve source schema";
                }
            });
            structType = (StructType)schema2.get();
        }
        StructType sqlSchema = structType;
        return new Tuple2((Object)this.shortName(), (Object)sqlSchema);
    }

    public Source createSource(SQLContext sqlContext, String metadataPath, scala.Option<StructType> schema2, String providerName, Map<String, String> parameters) {
        return new HoodieStreamSource(sqlContext, metadataPath, schema2, parameters);
    }

    public DefaultSource() {
        SparkSession$.MODULE$.getActiveSession().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SparkSession spark) {
                String sparkVersion = spark.version();
                if (sparkVersion.startsWith("0.") || sparkVersion.startsWith("1.") || sparkVersion.startsWith("2.")) {
                    spark.conf().set("spark.sql.legacy.sources.write.passPartitionByAsOptions", "true");
                }
            }
        });
        this.log = LogManager.getLogger(DefaultSource.class);
    }
}

