/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class HoodieDatasetBulkInsertHelper {
    private static final Logger LOG = LogManager.getLogger(HoodieDatasetBulkInsertHelper.class);
    private static final String RECORD_KEY_UDF_FN = "hudi_recordkey_gen_function";
    private static final String PARTITION_PATH_UDF_FN = "hudi_partition_gen_function";

    public static Dataset<Row> prepareHoodieDatasetForBulkInsert(SQLContext sqlContext, HoodieWriteConfig config, Dataset<Row> rows, String structName, String recordNamespace) {
        List originalFields = Arrays.stream(rows.schema().fields()).map(f -> new Column(f.name())).collect(Collectors.toList());
        TypedProperties properties = new TypedProperties();
        properties.putAll((Map<?, ?>)config.getProps());
        String keyGeneratorClass = properties.getString(DataSourceWriteOptions.KEYGENERATOR_CLASS_OPT_KEY());
        BuiltinKeyGenerator keyGenerator = (BuiltinKeyGenerator)ReflectionUtils.loadClass(keyGeneratorClass, properties);
        StructType structTypeForUDF = rows.schema();
        sqlContext.udf().register(RECORD_KEY_UDF_FN, keyGenerator::getRecordKey, DataTypes.StringType);
        sqlContext.udf().register(PARTITION_PATH_UDF_FN, keyGenerator::getPartitionPath, DataTypes.StringType);
        Dataset rowDatasetWithRecordKeys = rows.withColumn("_hoodie_record_key", functions.callUDF((String)RECORD_KEY_UDF_FN, (Column[])new Column[]{functions.struct((Seq)((Iterable)JavaConverters.collectionAsScalaIterableConverter(originalFields).asScala()).toSeq())}));
        Dataset rowDatasetWithRecordKeysAndPartitionPath = rowDatasetWithRecordKeys.withColumn("_hoodie_partition_path", functions.callUDF((String)PARTITION_PATH_UDF_FN, (Column[])new Column[]{functions.struct((Seq)((Iterable)JavaConverters.collectionAsScalaIterableConverter(originalFields).asScala()).toSeq())}));
        Dataset rowDatasetWithHoodieColumns = rowDatasetWithRecordKeysAndPartitionPath.withColumn("_hoodie_commit_time", functions.lit((Object)"").cast(DataTypes.StringType)).withColumn("_hoodie_commit_seqno", functions.lit((Object)"").cast(DataTypes.StringType)).withColumn("_hoodie_file_name", functions.lit((Object)"").cast(DataTypes.StringType));
        List orderedFields = Stream.concat(HoodieRecord.HOODIE_META_COLUMNS.stream().map(Column::new), originalFields.stream()).collect(Collectors.toList());
        Dataset colOrderedDataset = rowDatasetWithHoodieColumns.select(((Iterable)JavaConverters.collectionAsScalaIterableConverter(orderedFields).asScala()).toSeq());
        return colOrderedDataset.sort(new Column[]{functions.col((String)"_hoodie_partition_path"), functions.col((String)"_hoodie_record_key")}).coalesce(config.getBulkInsertShuffleParallelism());
    }
}

