/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionHelper$;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.Spark2RowSerDe;
import org.apache.hudi.Spark3RowSerDe;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.spark.org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.FileStatusCache$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;

public final class HoodieSparkUtils$ {
    public static final HoodieSparkUtils$ MODULE$;

    static {
        new HoodieSparkUtils$();
    }

    public StructType getMetaSchema() {
        return StructType$.MODULE$.apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(String col) {
                return new StructField(col, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    public boolean isGlobPath(Path pattern) {
        Set set = new StringOps(Predef$.MODULE$.augmentString("{}[]*?\\")).toSet();
        return new StringOps(Predef$.MODULE$.augmentString(pattern.toString())).exists((Function1)new Serializable(set){
            public static final long serialVersionUID = 0L;
            private final Set eta$0$1$1;

            public final boolean apply(Object elem) {
                return this.eta$0$1$1.contains(elem);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    public Seq<Path> globPath(FileSystem fs, Path pattern) {
        return (Seq)Option$.MODULE$.apply((Object)fs.globStatus(pattern)).map((Function1)new Serializable(fs){
            public static final long serialVersionUID = 0L;
            public final FileSystem fs$2;

            public final Seq<Path> apply(FileStatus[] statuses) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])statuses).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.globPath.1 $outer;

                    public final Path apply(FileStatus x$1) {
                        return x$1.getPath().makeQualified(this.$outer.fs$2.getUri(), this.$outer.fs$2.getWorkingDirectory());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).toSeq();
            }
            {
                this.fs$2 = fs$2;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Path> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public Seq<Path> globPathIfNecessary(FileSystem fs, Path pattern) {
        return this.isGlobPath(pattern) ? this.globPath(fs, pattern) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{pattern}));
    }

    public Seq<Path> checkAndGlobPathIfNecessary(Seq<String> paths, FileSystem fs) {
        return (Seq)paths.flatMap((Function1)new Serializable(fs){
            public static final long serialVersionUID = 0L;
            private final FileSystem fs$1;

            /*
             * WARNING - void declaration
             */
            public final Seq<Path> apply(String path) {
                void var3_3;
                Path qualified = new Path(path).makeQualified(this.fs$1.getUri(), this.fs$1.getWorkingDirectory());
                Seq<Path> globPaths = HoodieSparkUtils$.MODULE$.globPathIfNecessary(this.fs$1, qualified);
                return var3_3;
            }
            {
                this.fs$1 = fs$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public InMemoryFileIndex createInMemoryFileIndex(SparkSession sparkSession, Seq<Path> globbedPaths) {
        FileStatusCache fileStatusCache = FileStatusCache$.MODULE$.getOrCreate(sparkSession);
        return new InMemoryFileIndex(sparkSession, globbedPaths, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), Option$.MODULE$.empty(), fileStatusCache);
    }

    public RDD<GenericRecord> createRdd(Dataset<Row> df, String structName, String recordNamespace) {
        Schema avroSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(df.schema(), structName, recordNamespace);
        return this.createRdd(df, avroSchema, structName, recordNamespace);
    }

    public RDD<GenericRecord> createRdd(Dataset<Row> df, Schema avroSchema, String structName, String recordNamespace) {
        StructType dataType = (StructType)SchemaConverters$.MODULE$.toSqlType(avroSchema).dataType();
        ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(dataType);
        Seq x$2 = qual$1.resolveAndBind$default$1();
        Analyzer x$3 = qual$1.resolveAndBind$default$2();
        ExpressionEncoder encoder = qual$1.resolveAndBind(x$2, x$3);
        SparkRowSerDe deserializer = this.createRowSerDe((ExpressionEncoder<Row>)encoder);
        RDD qual$2 = df.queryExecution().toRdd().map((Function1)new Serializable(deserializer){
            public static final long serialVersionUID = 0L;
            private final SparkRowSerDe deserializer$1;

            public final Row apply(InternalRow row) {
                return this.deserializer$1.deserializeRow(row);
            }
            {
                this.deserializer$1 = deserializer$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        Serializable x$4 = new Serializable(structName, recordNamespace, dataType){
            public static final long serialVersionUID = 0L;
            private final String structName$1;
            private final String recordNamespace$1;
            private final StructType dataType$1;

            public final Iterator<GenericRecord> apply(Iterator<Row> records) {
                Iterator iterator2;
                if (records.isEmpty()) {
                    iterator2 = package$.MODULE$.Iterator().empty();
                } else {
                    Function1<Object, Object> convertor = AvroConversionHelper$.MODULE$.createConverterToAvro((DataType)this.dataType$1, this.structName$1, this.recordNamespace$1);
                    iterator2 = records.map((Function1)new Serializable(this, convertor){
                        public static final long serialVersionUID = 0L;
                        private final Function1 convertor$1;

                        public final GenericRecord apply(Row x) {
                            return (GenericRecord)this.convertor$1.apply((Object)x);
                        }
                        {
                            this.convertor$1 = convertor$1;
                        }
                    });
                }
                return iterator2;
            }
            {
                this.structName$1 = structName$1;
                this.recordNamespace$1 = recordNamespace$1;
                this.dataType$1 = dataType$1;
            }
        };
        boolean x$5 = qual$2.mapPartitions$default$2();
        return qual$2.mapPartitions((Function1)x$4, x$5, ClassTag$.MODULE$.apply(GenericRecord.class));
    }

    public SparkRowSerDe createRowSerDe(ExpressionEncoder<Row> encoder) {
        return org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("2.") ? new Spark2RowSerDe(encoder) : new Spark3RowSerDe(encoder);
    }

    private HoodieSparkUtils$() {
        MODULE$ = this;
    }
}

