/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.bootstrap;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.client.bootstrap.FullRecordBootstrapDataProvider;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.bootstrap.FileStatusUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class SparkParquetBootstrapDataProvider
extends FullRecordBootstrapDataProvider<JavaRDD<HoodieRecord>> {
    private final transient SparkSession sparkSession;

    public SparkParquetBootstrapDataProvider(TypedProperties props, HoodieSparkEngineContext context) {
        super(props, context);
        this.sparkSession = SparkSession.builder().config(context.getJavaSparkContext().getConf()).getOrCreate();
    }

    @Override
    public JavaRDD<HoodieRecord> generateInputRecords(String tableName, String sourceBasePath, List<Pair<String, List<HoodieFileStatus>>> partitionPathsWithFiles) {
        String[] filePaths = (String[])partitionPathsWithFiles.stream().map(Pair::getValue).flatMap(f -> f.stream().map(fs -> FileStatusUtils.toPath(fs.getPath()).toString())).toArray(String[]::new);
        Dataset inputDataset = this.sparkSession.read().parquet(filePaths);
        try {
            KeyGenerator keyGenerator = DataSourceUtils.createKeyGenerator(this.props);
            String structName = tableName + "_record";
            String namespace = "hoodie." + tableName;
            RDD<GenericRecord> genericRecords = HoodieSparkUtils.createRdd((Dataset<Row>)inputDataset, structName, namespace);
            return genericRecords.toJavaRDD().map((Function & Serializable)gr -> {
                String orderingVal = HoodieAvroUtils.getNestedFieldValAsString(gr, this.props.getString("hoodie.datasource.write.precombine.field"), false);
                try {
                    return DataSourceUtils.createHoodieRecord(gr, (Comparable)((Object)orderingVal), keyGenerator.getKey((GenericRecord)gr), this.props.getString("hoodie.datasource.write.payload.class"));
                }
                catch (IOException ioe) {
                    throw new HoodieIOException(ioe.getMessage(), ioe);
                }
            });
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }
}

