/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.callback.client.http;

import java.io.Closeable;
import java.io.IOException;
import java.util.Properties;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieWriteCommitHttpCallbackClient
implements Closeable {
    private static final Logger LOG = LogManager.getLogger(HoodieWriteCommitHttpCallbackClient.class);
    public static final String HEADER_KEY_API_KEY = "HUDI-CALLBACK-KEY";
    private final String apiKey;
    private final String url;
    private final CloseableHttpClient client;
    private Properties props;

    public HoodieWriteCommitHttpCallbackClient(HoodieWriteConfig config) {
        this.props = config.getProps();
        this.apiKey = this.getApiKey();
        this.url = this.getUrl();
        this.client = this.getClient();
    }

    public HoodieWriteCommitHttpCallbackClient(String apiKey, String url, CloseableHttpClient client) {
        this.apiKey = apiKey;
        this.url = url;
        this.client = client;
    }

    public void send(String callbackMsg) {
        HttpPost request = new HttpPost(this.url);
        request.setHeader(HEADER_KEY_API_KEY, this.apiKey);
        request.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        request.setEntity(new StringEntity(callbackMsg, ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse response = this.client.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 300) {
                LOG.warn((Object)String.format("Failed to send callback message. Response was %s", response));
            } else {
                LOG.info((Object)String.format("Sent Callback data %s to %s successfully !", callbackMsg, this.url));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to send callback.", (Throwable)e);
        }
    }

    private String getApiKey() {
        return this.props.getProperty("hoodie.write.commit.callback.http.api.key");
    }

    private String getUrl() {
        return this.props.getProperty("hoodie.write.commit.callback.http.url");
    }

    private CloseableHttpClient getClient() {
        int timeoutSeconds = this.getHttpTimeoutSeconds() * 1000;
        return HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(timeoutSeconds).setConnectionRequestTimeout(timeoutSeconds).setSocketTimeout(timeoutSeconds).build()).build();
    }

    private Integer getHttpTimeoutSeconds() {
        return Integer.parseInt(this.props.getProperty("hoodie.write.commit.callback.http.timeout.seconds"));
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

