/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.util.Utils;

public class SparkTaskContextSupplier
extends TaskContextSupplier
implements Serializable {
    @Override
    public Supplier<Integer> getPartitionIdSupplier() {
        return TaskContext::getPartitionId;
    }

    @Override
    public Supplier<Integer> getStageIdSupplier() {
        return () -> TaskContext.get().stageId();
    }

    @Override
    public Supplier<Long> getAttemptIdSupplier() {
        return () -> TaskContext.get().taskAttemptId();
    }

    @Override
    public Option<String> getProperty(EngineProperty prop) {
        if (prop == EngineProperty.TOTAL_MEMORY_AVAILABLE) {
            String DEFAULT_SPARK_EXECUTOR_MEMORY_MB = "1024";
            String SPARK_EXECUTOR_MEMORY_PROP = "spark.executor.memory";
            if (SparkEnv.get() != null) {
                return Option.ofNullable(String.valueOf((long)(Utils.memoryStringToMb((String)SparkEnv.get().conf().get("spark.executor.memory", "1024")) * 1024) * 1024L));
            }
            return Option.empty();
        }
        if (prop == EngineProperty.MEMORY_FRACTION_IN_USE) {
            String DEFAULT_SPARK_EXECUTOR_MEMORY_FRACTION = "0.6";
            String SPARK_EXECUTOR_MEMORY_FRACTION_PROP = "spark.memory.fraction";
            if (SparkEnv.get() != null) {
                return Option.ofNullable(SparkEnv.get().conf().get("spark.memory.fraction", "0.6"));
            }
            return Option.empty();
        }
        throw new HoodieException("Unknown engine property :" + (Object)((Object)prop));
    }
}

