/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.MercifulJsonConverter;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;

public class HoodieJsonPayload
implements HoodieRecordPayload<HoodieJsonPayload> {
    private byte[] jsonDataCompressed;
    private int dataSize;

    public HoodieJsonPayload(String json2) throws IOException {
        this.jsonDataCompressed = this.compressData(json2);
        this.dataSize = json2.length();
    }

    @Override
    public HoodieJsonPayload preCombine(HoodieJsonPayload another) {
        return this;
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord oldRec, Schema schema2) throws IOException {
        return this.getInsertValue(schema2);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema2) throws IOException {
        MercifulJsonConverter jsonConverter = new MercifulJsonConverter();
        return Option.of(jsonConverter.convert(this.getJsonData(), schema2));
    }

    private String getJsonData() throws IOException {
        return this.unCompressData(this.jsonDataCompressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] compressData(String jsonData) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(9);
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, deflater, true);
        try {
            dos.write(jsonData.getBytes());
        }
        finally {
            dos.flush();
            dos.close();
            deflater.end();
        }
        return baos.toByteArray();
    }

    private String unCompressData(byte[] data) throws IOException {
        try (InflaterInputStream iis = new InflaterInputStream(new ByteArrayInputStream(data));){
            String string = FileIOUtils.readAsUTFString(iis, this.dataSize);
            return string;
        }
    }

    private String getFieldFromJsonOrFail(String field) throws IOException {
        JsonNode node = new ObjectMapper().readTree(this.getJsonData());
        if (!node.has(field)) {
            throw new HoodieException("Field :" + field + " not found in payload => " + node.toString());
        }
        return node.get(field).textValue();
    }

    public String getRowKey(String keyColumnField) throws IOException {
        return this.getFieldFromJsonOrFail(keyColumnField);
    }

    public String getPartitionPath(String partitionPathField) throws IOException {
        return this.getFieldFromJsonOrFail(partitionPathField);
    }
}

