/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.function;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.hudi.common.function.SerializableConsumer;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;

public class FunctionWrapper {
    public static <I, O> Function<I, O> throwingMapWrapper(SerializableFunction<I, O> throwingMapFunction) {
        return v1 -> {
            try {
                return throwingMapFunction.apply(v1);
            }
            catch (Exception e) {
                throw new HoodieException("Error occurs when executing map", e);
            }
        };
    }

    public static <I, O> Function<I, Stream<O>> throwingFlatMapWrapper(SerializableFunction<I, Stream<O>> throwingFlatMapFunction) {
        return v1 -> {
            try {
                return (Stream)throwingFlatMapFunction.apply(v1);
            }
            catch (Exception e) {
                throw new HoodieException("Error occurs when executing flatMap", e);
            }
        };
    }

    public static <I> Consumer<I> throwingForeachWrapper(SerializableConsumer<I> throwingConsumer) {
        return v1 -> {
            try {
                throwingConsumer.accept(v1);
            }
            catch (Exception e) {
                throw new HoodieException("Error occurs when executing foreach", e);
            }
        };
    }

    public static <I, K, V> Function<I, Pair<K, V>> throwingMapToPairWrapper(SerializablePairFunction<I, K, V> throwingPairFunction) {
        return v1 -> {
            try {
                return throwingPairFunction.call(v1);
            }
            catch (Exception e) {
                throw new HoodieException("Error occurs when executing mapToPair", e);
            }
        };
    }
}

