/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.metrics;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hudi.common.metrics.LocalRegistry;
import org.apache.hudi.common.util.ReflectionUtils;

public interface Registry
extends Serializable {
    public static final ConcurrentHashMap<String, Registry> REGISTRY_MAP = new ConcurrentHashMap();

    public static Registry getRegistry(String registryName) {
        return Registry.getRegistry(registryName, LocalRegistry.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry getRegistry(String registryName, String clazz) {
        Class<Registry> clazz2 = Registry.class;
        synchronized (Registry.class) {
            if (!REGISTRY_MAP.containsKey(registryName)) {
                Registry registry = (Registry)ReflectionUtils.loadClass(clazz, registryName);
                REGISTRY_MAP.put(registryName, registry);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return REGISTRY_MAP.get(registryName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Long> getAllMetrics(boolean flush, boolean prefixWithRegistryName) {
        Class<Registry> clazz = Registry.class;
        synchronized (Registry.class) {
            HashMap<String, Long> allMetrics = new HashMap<String, Long>();
            REGISTRY_MAP.forEach((registryName, registry) -> {
                allMetrics.putAll(registry.getAllCounts(prefixWithRegistryName));
                if (flush) {
                    registry.clear();
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return allMetrics;
        }
    }

    public void clear();

    public void increment(String var1);

    public void add(String var1, long var2);

    default public Map<String, Long> getAllCounts() {
        return this.getAllCounts(false);
    }

    public Map<String, Long> getAllCounts(boolean var1);
}

