/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;

public class HoodieAvroPayload
implements HoodieRecordPayload<HoodieAvroPayload> {
    private final byte[] recordBytes;

    public HoodieAvroPayload(Option<GenericRecord> record) {
        this.recordBytes = record.isPresent() ? HoodieAvroUtils.avroToBytes(record.get()) : new byte[0];
    }

    @Override
    public HoodieAvroPayload preCombine(HoodieAvroPayload another) {
        return this;
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema2) throws IOException {
        return this.getInsertValue(schema2);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema2) throws IOException {
        if (this.recordBytes.length == 0) {
            return Option.empty();
        }
        return Option.of(HoodieAvroUtils.bytesToAvro(this.recordBytes, schema2));
    }

    public byte[] getRecordBytes() {
        return this.recordBytes;
    }
}

