/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.io.storage.HoodieFileReader;

public class HoodieFileSliceReader
implements Iterator<HoodieRecord<? extends HoodieRecordPayload>> {
    private Iterator<HoodieRecord<? extends HoodieRecordPayload>> recordsIterator;

    public static <R extends IndexedRecord, T extends HoodieRecordPayload> HoodieFileSliceReader getFileSliceReader(HoodieFileReader<R> baseFileReader, HoodieMergedLogRecordScanner scanner, Schema schema2, String payloadClass) throws IOException {
        Iterator<R> baseIterator = baseFileReader.getRecordIterator(schema2);
        while (baseIterator.hasNext()) {
            GenericRecord record = (GenericRecord)baseIterator.next();
            HoodieRecord hoodieRecord = (HoodieRecord)SpillableMapUtils.convertToHoodieRecordPayload(record, payloadClass);
            scanner.processNextRecord(hoodieRecord);
        }
        return new HoodieFileSliceReader(scanner.iterator());
    }

    private HoodieFileSliceReader(Iterator<HoodieRecord<? extends HoodieRecordPayload>> recordsItr) {
        this.recordsIterator = recordsItr;
    }

    @Override
    public boolean hasNext() {
        return this.recordsIterator.hasNext();
    }

    @Override
    public HoodieRecord<? extends HoodieRecordPayload> next() {
        return this.recordsIterator.next();
    }
}

