/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.AbstractHoodieLogRecordScanner;

public class HoodieUnMergedLogRecordScanner
extends AbstractHoodieLogRecordScanner {
    private final LogRecordScannerCallback callback;

    public HoodieUnMergedLogRecordScanner(FileSystem fs, String basePath, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, boolean readBlocksLazily, boolean reverseReader, int bufferSize, LogRecordScannerCallback callback) {
        super(fs, basePath, logFilePaths, readerSchema, latestInstantTime, readBlocksLazily, reverseReader, bufferSize);
        this.callback = callback;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    protected void processNextRecord(HoodieRecord<? extends HoodieRecordPayload> hoodieRecord) throws Exception {
        this.callback.apply(hoodieRecord);
    }

    @Override
    protected void processNextDeletedKey(HoodieKey key) {
        throw new IllegalStateException("Not expected to see delete records in this log-scan mode. Check Job Config");
    }

    public static class Builder
    extends AbstractHoodieLogRecordScanner.Builder {
        private FileSystem fs;
        private String basePath;
        private List<String> logFilePaths;
        private Schema readerSchema;
        private String latestInstantTime;
        private boolean readBlocksLazily;
        private boolean reverseReader;
        private int bufferSize;
        private LogRecordScannerCallback callback;

        @Override
        public Builder withFileSystem(FileSystem fs) {
            this.fs = fs;
            return this;
        }

        @Override
        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Override
        public Builder withLogFilePaths(List<String> logFilePaths) {
            this.logFilePaths = logFilePaths;
            return this;
        }

        @Override
        public Builder withReaderSchema(Schema schema2) {
            this.readerSchema = schema2;
            return this;
        }

        @Override
        public Builder withLatestInstantTime(String latestInstantTime) {
            this.latestInstantTime = latestInstantTime;
            return this;
        }

        @Override
        public Builder withReadBlocksLazily(boolean readBlocksLazily) {
            this.readBlocksLazily = readBlocksLazily;
            return this;
        }

        @Override
        public Builder withReverseReader(boolean reverseReader) {
            this.reverseReader = reverseReader;
            return this;
        }

        @Override
        public Builder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder withLogRecordScannerCallback(LogRecordScannerCallback callback) {
            this.callback = callback;
            return this;
        }

        @Override
        public HoodieUnMergedLogRecordScanner build() {
            return new HoodieUnMergedLogRecordScanner(this.fs, this.basePath, this.logFilePaths, this.readerSchema, this.latestInstantTime, this.readBlocksLazily, this.reverseReader, this.bufferSize, this.callback);
        }
    }

    @FunctionalInterface
    public static interface LogRecordScannerCallback {
        public void apply(HoodieRecord<? extends HoodieRecordPayload> var1) throws Exception;
    }
}

