/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.parquet.hadoop.ParquetReader;

public class ParquetReaderIterator<T>
implements Iterator<T> {
    private final ParquetReader<T> parquetReader;
    private T next;

    public ParquetReaderIterator(ParquetReader<T> parquetReader) {
        this.parquetReader = parquetReader;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.next == null) {
                this.next = this.parquetReader.read();
            }
            return this.next != null;
        }
        catch (IOException io) {
            throw new HoodieIOException("unable to read next record from parquet file ", io);
        }
    }

    @Override
    public T next() {
        try {
            if (this.next == null && !this.hasNext()) {
                throw new HoodieIOException("No more records left to read from parquet file");
            }
            T retVal = this.next;
            this.next = this.parquetReader.read();
            return retVal;
        }
        catch (IOException io) {
            throw new HoodieIOException("unable to read next record from parquet file ", io);
        }
    }

    public void close() throws IOException {
        this.parquetReader.close();
    }
}

