/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hudi.common.util.ObjectSizeCalculator;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.collection.DiskBasedMap;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ExternalSpillableMap<T extends Serializable, R extends Serializable>
implements Map<T, R> {
    private static final int NUMBER_OF_RECORDS_TO_ESTIMATE_PAYLOAD_SIZE = 100;
    private static final Logger LOG = LogManager.getLogger(ExternalSpillableMap.class);
    private final long maxInMemorySizeInBytes;
    private final Map<T, R> inMemoryMap = new HashMap<T, R>();
    private volatile transient DiskBasedMap<T, R> diskBasedMap;
    private final Double sizingFactorForInMemoryMap = 0.8;
    private final SizeEstimator<T> keySizeEstimator;
    private final SizeEstimator<R> valueSizeEstimator;
    private Long currentInMemoryMapSize;
    private volatile long estimatedPayloadSize = 0L;
    private boolean shouldEstimatePayloadSize = true;
    private final String baseFilePath;

    public ExternalSpillableMap(Long maxInMemorySizeInBytes, String baseFilePath, SizeEstimator<T> keySizeEstimator, SizeEstimator<R> valueSizeEstimator) throws IOException {
        this.baseFilePath = baseFilePath;
        this.diskBasedMap = new DiskBasedMap(baseFilePath);
        this.maxInMemorySizeInBytes = (long)Math.floor((double)maxInMemorySizeInBytes.longValue() * this.sizingFactorForInMemoryMap);
        this.currentInMemoryMapSize = 0L;
        this.keySizeEstimator = keySizeEstimator;
        this.valueSizeEstimator = valueSizeEstimator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiskBasedMap<T, R> getDiskBasedMap() {
        if (null == this.diskBasedMap) {
            ExternalSpillableMap externalSpillableMap = this;
            synchronized (externalSpillableMap) {
                if (null == this.diskBasedMap) {
                    try {
                        this.diskBasedMap = new DiskBasedMap(this.baseFilePath);
                    }
                    catch (IOException e) {
                        throw new HoodieIOException(e.getMessage(), e);
                    }
                }
            }
        }
        return this.diskBasedMap;
    }

    public Iterator<R> iterator() {
        return new IteratorWrapper<R>(this.inMemoryMap.values().iterator(), this.getDiskBasedMap().iterator());
    }

    public int getDiskBasedMapNumEntries() {
        return this.getDiskBasedMap().size();
    }

    public long getSizeOfFileOnDiskInBytes() {
        return this.getDiskBasedMap().sizeOfFileOnDiskInBytes();
    }

    public int getInMemoryMapNumEntries() {
        return this.inMemoryMap.size();
    }

    public long getCurrentInMemoryMapSize() {
        return this.currentInMemoryMapSize;
    }

    @Override
    public int size() {
        return this.inMemoryMap.size() + this.getDiskBasedMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.inMemoryMap.isEmpty() && this.getDiskBasedMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.inMemoryMap.containsKey(key) || this.getDiskBasedMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inMemoryMap.containsValue(value) || this.getDiskBasedMap().containsValue(value);
    }

    @Override
    public R get(Object key) {
        if (this.inMemoryMap.containsKey(key)) {
            return (R)((Serializable)this.inMemoryMap.get(key));
        }
        if (this.getDiskBasedMap().containsKey(key)) {
            return (R)this.getDiskBasedMap().get(key);
        }
        return null;
    }

    @Override
    public R put(T key, R value) {
        if (this.currentInMemoryMapSize < this.maxInMemorySizeInBytes || this.inMemoryMap.containsKey(key)) {
            if (this.shouldEstimatePayloadSize && this.estimatedPayloadSize == 0L) {
                this.estimatedPayloadSize = this.keySizeEstimator.sizeEstimate(key) + this.valueSizeEstimator.sizeEstimate(value);
                LOG.info((Object)("Estimated Payload size => " + this.estimatedPayloadSize));
            } else if (this.shouldEstimatePayloadSize && this.inMemoryMap.size() % 100 == 0) {
                long totalMapSize = ObjectSizeCalculator.getObjectSize(this.inMemoryMap);
                this.currentInMemoryMapSize = totalMapSize;
                this.estimatedPayloadSize = totalMapSize / (long)this.inMemoryMap.size();
                this.shouldEstimatePayloadSize = false;
                LOG.info((Object)("New Estimated Payload size => " + this.estimatedPayloadSize));
            }
            if (!this.inMemoryMap.containsKey(key)) {
                this.currentInMemoryMapSize = this.currentInMemoryMapSize + this.estimatedPayloadSize;
            }
            this.inMemoryMap.put(key, value);
        } else {
            this.getDiskBasedMap().put(key, value);
        }
        return value;
    }

    @Override
    public R remove(Object key) {
        if (this.inMemoryMap.containsKey(key)) {
            this.currentInMemoryMapSize = this.currentInMemoryMapSize - this.estimatedPayloadSize;
            return (R)((Serializable)this.inMemoryMap.remove(key));
        }
        if (this.getDiskBasedMap().containsKey(key)) {
            return (R)this.getDiskBasedMap().remove(key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends T, ? extends R> m) {
        for (Map.Entry<T, R> entry : m.entrySet()) {
            this.put((T)((Serializable)entry.getKey()), (R)((Serializable)entry.getValue()));
        }
    }

    @Override
    public void clear() {
        this.inMemoryMap.clear();
        this.getDiskBasedMap().clear();
        this.currentInMemoryMapSize = 0L;
    }

    public void close() {
        this.getDiskBasedMap().close();
    }

    @Override
    public Set<T> keySet() {
        HashSet<T> keySet = new HashSet<T>();
        keySet.addAll(this.inMemoryMap.keySet());
        keySet.addAll(this.getDiskBasedMap().keySet());
        return keySet;
    }

    @Override
    public Collection<R> values() {
        if (this.getDiskBasedMap().isEmpty()) {
            return this.inMemoryMap.values();
        }
        ArrayList<R> result = new ArrayList<R>(this.inMemoryMap.values());
        result.addAll(this.getDiskBasedMap().values());
        return result;
    }

    public Stream<R> valueStream() {
        return Stream.concat(this.inMemoryMap.values().stream(), this.getDiskBasedMap().valueStream());
    }

    @Override
    public Set<Map.Entry<T, R>> entrySet() {
        HashSet<Map.Entry<T, R>> entrySet = new HashSet<Map.Entry<T, R>>();
        entrySet.addAll(this.inMemoryMap.entrySet());
        entrySet.addAll(this.getDiskBasedMap().entrySet());
        return entrySet;
    }

    private class IteratorWrapper<R>
    implements Iterator<R> {
        private Iterator<R> inMemoryIterator;
        private Iterator<R> diskLazyFileIterator;

        public IteratorWrapper(Iterator<R> inMemoryIterator, Iterator<R> diskLazyFileIterator) {
            this.inMemoryIterator = inMemoryIterator;
            this.diskLazyFileIterator = diskLazyFileIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.inMemoryIterator.hasNext()) {
                return true;
            }
            return this.diskLazyFileIterator.hasNext();
        }

        @Override
        public R next() {
            if (this.inMemoryIterator.hasNext()) {
                return this.inMemoryIterator.next();
            }
            return this.diskLazyFileIterator.next();
        }
    }
}

