/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.client.bootstrap.BootstrapMode;
import org.apache.hudi.client.bootstrap.selector.MetadataOnlyBootstrapModeSelector;
import org.apache.hudi.client.bootstrap.translator.IdentityBootstrapPartitionPathTranslator;
import org.apache.hudi.common.bootstrap.index.HFileBootstrapIndex;
import org.apache.hudi.common.config.DefaultHoodieConfig;

public class HoodieBootstrapConfig
extends DefaultHoodieConfig {
    public static final String BOOTSTRAP_BASE_PATH_PROP = "hoodie.bootstrap.base.path";
    public static final String BOOTSTRAP_MODE_SELECTOR = "hoodie.bootstrap.mode.selector";
    public static final String FULL_BOOTSTRAP_INPUT_PROVIDER = "hoodie.bootstrap.full.input.provider";
    public static final String DEFAULT_FULL_BOOTSTRAP_INPUT_PROVIDER = "org.apache.hudi.bootstrap.SparkParquetBootstrapDataProvider";
    public static final String BOOTSTRAP_KEYGEN_CLASS = "hoodie.bootstrap.keygen.class";
    public static final String BOOTSTRAP_PARTITION_PATH_TRANSLATOR_CLASS = "hoodie.bootstrap.partitionpath.translator.class";
    public static final String DEFAULT_BOOTSTRAP_PARTITION_PATH_TRANSLATOR_CLASS = IdentityBootstrapPartitionPathTranslator.class.getName();
    public static final String BOOTSTRAP_PARALLELISM = "hoodie.bootstrap.parallelism";
    public static final String DEFAULT_BOOTSTRAP_PARALLELISM = "1500";
    public static final String BOOTSTRAP_MODE_SELECTOR_REGEX = "hoodie.bootstrap.mode.selector.regex";
    public static final String BOOTSTRAP_MODE_SELECTOR_REGEX_MODE = "hoodie.bootstrap.mode.selector.regex.mode";
    public static final String DEFAULT_BOOTSTRAP_MODE_SELECTOR_REGEX = ".*";
    public static final String DEFAULT_BOOTSTRAP_MODE_SELECTOR_REGEX_MODE = BootstrapMode.METADATA_ONLY.name();
    public static final String BOOTSTRAP_INDEX_CLASS_PROP = "hoodie.bootstrap.index.class";
    public static final String DEFAULT_BOOTSTRAP_INDEX_CLASS = HFileBootstrapIndex.class.getName();

    public HoodieBootstrapConfig(Properties props) {
        super(props);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Properties props = new Properties();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder withBootstrapBasePath(String basePath) {
            this.props.setProperty(HoodieBootstrapConfig.BOOTSTRAP_BASE_PATH_PROP, basePath);
            return this;
        }

        public Builder withBootstrapModeSelector(String partitionSelectorClass) {
            this.props.setProperty(HoodieBootstrapConfig.BOOTSTRAP_MODE_SELECTOR, partitionSelectorClass);
            return this;
        }

        public Builder withFullBootstrapInputProvider(String partitionSelectorClass) {
            this.props.setProperty(HoodieBootstrapConfig.FULL_BOOTSTRAP_INPUT_PROVIDER, partitionSelectorClass);
            return this;
        }

        public Builder withBootstrapKeyGenClass(String keyGenClass) {
            this.props.setProperty(HoodieBootstrapConfig.BOOTSTRAP_KEYGEN_CLASS, keyGenClass);
            return this;
        }

        public Builder withBootstrapPartitionPathTranslatorClass(String partitionPathTranslatorClass) {
            this.props.setProperty(HoodieBootstrapConfig.BOOTSTRAP_PARTITION_PATH_TRANSLATOR_CLASS, partitionPathTranslatorClass);
            return this;
        }

        public Builder withBootstrapParallelism(int parallelism) {
            this.props.setProperty(HoodieBootstrapConfig.BOOTSTRAP_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withBootstrapModeSelectorRegex(String regex) {
            this.props.setProperty(HoodieBootstrapConfig.BOOTSTRAP_MODE_SELECTOR_REGEX, regex);
            return this;
        }

        public Builder withBootstrapModeForRegexMatch(BootstrapMode modeForRegexMatch) {
            this.props.setProperty(HoodieBootstrapConfig.BOOTSTRAP_MODE_SELECTOR_REGEX_MODE, modeForRegexMatch.name());
            return this;
        }

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public HoodieBootstrapConfig build() {
            HoodieBootstrapConfig config = new HoodieBootstrapConfig(this.props);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieBootstrapConfig.BOOTSTRAP_PARALLELISM), HoodieBootstrapConfig.BOOTSTRAP_PARALLELISM, HoodieBootstrapConfig.DEFAULT_BOOTSTRAP_PARALLELISM);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieBootstrapConfig.BOOTSTRAP_PARTITION_PATH_TRANSLATOR_CLASS), HoodieBootstrapConfig.BOOTSTRAP_PARTITION_PATH_TRANSLATOR_CLASS, DEFAULT_BOOTSTRAP_PARTITION_PATH_TRANSLATOR_CLASS);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieBootstrapConfig.BOOTSTRAP_MODE_SELECTOR), HoodieBootstrapConfig.BOOTSTRAP_MODE_SELECTOR, MetadataOnlyBootstrapModeSelector.class.getCanonicalName());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieBootstrapConfig.BOOTSTRAP_MODE_SELECTOR_REGEX), HoodieBootstrapConfig.BOOTSTRAP_MODE_SELECTOR_REGEX, HoodieBootstrapConfig.DEFAULT_BOOTSTRAP_MODE_SELECTOR_REGEX);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieBootstrapConfig.BOOTSTRAP_MODE_SELECTOR_REGEX_MODE), HoodieBootstrapConfig.BOOTSTRAP_MODE_SELECTOR_REGEX_MODE, DEFAULT_BOOTSTRAP_MODE_SELECTOR_REGEX_MODE);
            BootstrapMode.valueOf(this.props.getProperty(HoodieBootstrapConfig.BOOTSTRAP_MODE_SELECTOR_REGEX_MODE));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieBootstrapConfig.BOOTSTRAP_INDEX_CLASS_PROP), HoodieBootstrapConfig.BOOTSTRAP_INDEX_CLASS_PROP, DEFAULT_BOOTSTRAP_INDEX_CLASS);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieBootstrapConfig.FULL_BOOTSTRAP_INPUT_PROVIDER), HoodieBootstrapConfig.FULL_BOOTSTRAP_INPUT_PROVIDER, HoodieBootstrapConfig.DEFAULT_FULL_BOOTSTRAP_INPUT_PROVIDER);
            return config;
        }
    }
}

